package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 关联商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 客户类型
   */
  @TableField("customerType")
  private String customerType;

  /**
   * 客户编码
   */
  @TableField("customerCode")
  private String customerCode;

  /**
   * 客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 送达方编码
   */
  @TableField("shipToCode")
  private String shipToCode;

  /**
   * 送达方GLN
   */
  @TableField("shipToGLN")
  private String shipToGLN;

  /**
   * 送达方名称
   */
  @TableField("shipToName")
  private String shipToName;

  /**
   * 购方门店地址
   */
  @TableField("purchaseStoreAddress")
  private String purchaseStoreAddress;

  /**
   * 收货地址
   */
  @TableField("receiveAddress")
  private String receiveAddress;

  /**
   * 收货联系人
   */
  @TableField("receiveContactPerson")
  private String receiveContactPerson;

  /**
   * 购方联系电话
   */
  @TableField("purchasePhone")
  private String purchasePhone;

  /**
   * 购方传真
   */
  @TableField("purchaseFax")
  private String purchaseFax;

  /**
   * 购方邮箱
   */
  @TableField("purchaseEmail")
  private String purchaseEmail;

  /**
   * 销方类型
   */
  @TableField("sellerType")
  private String sellerType;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 销方公司编码
   */
  @TableField("sellerCompanyCode")
  private String sellerCompanyCode;

  /**
   * 销方公司名称
   */
  @TableField("sellerCompanyName")
  private String sellerCompanyName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销售组织编码
   */
  @TableField("salesOrganizationCode")
  private String salesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("salesOrganizationName")
  private String salesOrganizationName;

  /**
   * 制单员编码
   */
  @TableField("createdByCode")
  private String createdByCode;

  /**
   * 制单员
   */
  @TableField("createdByName")
  private String createdByName;

  /**
   * 销售员编码
   */
  @TableField("salesPersonCode")
  private String salesPersonCode;

  /**
   * 销售员
   */
  @TableField("salesPersonName")
  private String salesPersonName;

  /**
   * 销方联系电话
   */
  @TableField("sellerPhone")
  private String sellerPhone;

  /**
   * 销方传真
   */
  @TableField("sellerFax")
  private String sellerFax;

  /**
   * 销方邮箱
   */
  @TableField("sellerEmail")
  private String sellerEmail;

  /**
   * 厂商名称
   */
  @TableField("manufacturerName")
  private String manufacturerName;

  /**
   * 厂商编码
   */
  @TableField("manufacturerCode")
  private String manufacturerCode;

  /**
   * 销售出库单号
   */
  @TableField("salesDeliveryNo")
  private String salesDeliveryNo;

  /**
   * 销售订单号
   */
  @TableField("salesOrdNo")
  private String salesOrdNo;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 关联处采购订单ID
   */
  @TableField("associatedPOId")
  private String associatedPOId;

  /**
   * 关联采购订单编号
   */
  @TableField("associatedPONo")
  private String associatedPONo;

  /**
   * 关联单据编码
   */
  @TableField("associatedBillNo")
  private String associatedBillNo;

  /**
   * 采购订单日期
   */
  @TableField("purchaseDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime purchaseDate;

  /**
   * 采购请求交货日期
   */
  @TableField("purchaseRequestDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime purchaseRequestDate;

  /**
   * 销售合同号
   */
  @TableField("salesContractNo")
  private String salesContractNo;

  /**
   * 销售合同行号
   */
  @TableField("salesContractLineNo")
  private String salesContractLineNo;

  /**
   * 销售方式
   */
  @TableField("salesMethod")
  private String salesMethod;

  /**
   * 销售出库单类型
   */
  @TableField("salesType")
  private String salesType;

  /**
   * 单据日期
   */
  @TableField("salesDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime salesDate;

  /**
   * 创建日期
   */
  @TableField("creationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;

  /**
   * 更新日期
   */
  @TableField("updateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateDate;

  /**
   * 审批日期
   */
  @TableField("approveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approveDate;

  /**
   * 取消日期
   */
  @TableField("poCancelDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poCancelDate;

  /**
   * 总金额（含税）
   */
  @TableField("totalAmt")
  private BigDecimal totalAmt;

  /**
   * 总金额（不含税）
   */
  @TableField("totalAmtWithoutTax")
  private BigDecimal totalAmtWithoutTax;

  /**
   * 单据状态
   */
  @TableField("documentStatus")
  private String documentStatus;

  /**
   * 取消标识
   */
  @TableField("cancelFlag")
  private String cancelFlag;

  /**
   * 审批类型
   */
  @TableField("approveType")
  private String approveType;

  /**
   * 折扣总金额
   */
  @TableField("discountTotalAmt")
  private BigDecimal discountTotalAmt;

  /**
   * 折扣率
   */
  @TableField("discountRate")
  private BigDecimal discountRate;

  /**
   * 是否促销
   */
  @TableField("promtFlag")
  private String promtFlag;

  /**
   * 促销期数
   */
  @TableField("promtPeriod")
  private String promtPeriod;

  /**
   * 促销类型
   */
  @TableField("promtType")
  private String promtType;

  /**
   * 发运方式
   */
  @TableField("shipMethod")
  private String shipMethod;

  /**
   * 物流模式
   */
  @TableField("logisticsMode")
  private String logisticsMode;

  /**
   * 发货类型
   */
  @TableField("shipType")
  private String shipType;

  /**
   * 交货工厂编码
   */
  @TableField("deliveryFactoryCode")
  private String deliveryFactoryCode;

  /**
   * 交货工厂名称
   */
  @TableField("deliveryFactoryName")
  private String deliveryFactoryName;

  /**
   * 发货人员编码
   */
  @TableField("deliveryShipperCode")
  private String deliveryShipperCode;

  /**
   * 发货人员
   */
  @TableField("deliveryShipperName")
  private String deliveryShipperName;

  /**
   * 仓管员编码
   */
  @TableField("warehouseManagersCode")
  private String warehouseManagersCode;

  /**
   * 仓管员
   */
  @TableField("warehouseManagersName")
  private String warehouseManagersName;

  /**
   * 发货地址
   */
  @TableField("sellerShipAddress")
  private String sellerShipAddress;

  /**
   * 计划发货日期
   */
  @TableField("scheduleDeliveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scheduleDeliveryDate;

  /**
   * 发货日期
   */
  @TableField("deliveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryDate;

  /**
   * 实际收货日期
   */
  @TableField("receiveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiveDate;

  /**
   * 币种编码
   */
  @TableField("currencyCode")
  private String currencyCode;

  /**
   * 币种
   */
  private String currency;

  /**
   * 汇率日期
   */
  @TableField("exRateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exRateDate;

  /**
   * 汇率
   */
  @TableField("exRate")
  private BigDecimal exRate;

  /**
   * 汇率类型
   */
  @TableField("exRateType")
  private String exRateType;

  /**
   * 结算财务组织编码
   */
  @TableField("settlementOrgCode")
  private String settlementOrgCode;

  /**
   * 结算财务组织名称
   */
  @TableField("settlementOrgName")
  private String settlementOrgName;

  /**
   * 结算方式编码
   */
  @TableField("settlementCode")
  private String settlementCode;

  /**
   * 结算方式名称
   */
  @TableField("settlementName")
  private String settlementName;

  /**
   * 付款类型
   */
  @TableField("payType")
  private String payType;

  /**
   * 付款条件编码
   */
  @TableField("payCondtCode")
  private String payCondtCode;

  /**
   * 付款条件
   */
  @TableField("payCondt")
  private String payCondt;

  /**
   * 付款折扣
   */
  @TableField("payDiscount")
  private String payDiscount;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 业务id
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 是否最新版本
   */
  private Boolean latest;

  /**
   * 业务id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 销方单据状态
   */
  @TableField("pSellerDocStatus")
  private String pSellerDocStatus;

  /**
   * 销方开票状态
   */
  @TableField("pSellerInvoiceStatus")
  private String pSellerInvoiceStatus;

  /**
   * 销方对账状态
   */
  @TableField("pSellerReconStatus")
  private String pSellerReconStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("customerType", customerType);
      map.put("customerCode", customerCode);
      map.put("customerName", customerName);
      map.put("shipToCode", shipToCode);
      map.put("shipToGLN", shipToGLN);
      map.put("shipToName", shipToName);
      map.put("purchaseStoreAddress", purchaseStoreAddress);
      map.put("receiveAddress", receiveAddress);
      map.put("receiveContactPerson", receiveContactPerson);
      map.put("purchasePhone", purchasePhone);
      map.put("purchaseFax", purchaseFax);
      map.put("purchaseEmail", purchaseEmail);
      map.put("sellerType", sellerType);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("salesOrganizationCode", salesOrganizationCode);
      map.put("salesOrganizationName", salesOrganizationName);
      map.put("createdByCode", createdByCode);
      map.put("createdByName", createdByName);
      map.put("salesPersonCode", salesPersonCode);
      map.put("salesPersonName", salesPersonName);
      map.put("sellerPhone", sellerPhone);
      map.put("sellerFax", sellerFax);
      map.put("sellerEmail", sellerEmail);
      map.put("manufacturerName", manufacturerName);
      map.put("manufacturerCode", manufacturerCode);
      map.put("salesDeliveryNo", salesDeliveryNo);
      map.put("salesOrdNo", salesOrdNo);
      map.put("versionNo", versionNo);
      map.put("associatedPOId", associatedPOId);
      map.put("associatedPONo", associatedPONo);
      map.put("associatedBillNo", associatedBillNo);
      map.put("purchaseDate", BocpGenUtils.toTimestamp(purchaseDate));
      map.put("purchaseRequestDate", BocpGenUtils.toTimestamp(purchaseRequestDate));
      map.put("salesContractNo", salesContractNo);
      map.put("salesContractLineNo", salesContractLineNo);
      map.put("salesMethod", salesMethod);
      map.put("salesType", salesType);
      map.put("salesDate", BocpGenUtils.toTimestamp(salesDate));
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("updateDate", BocpGenUtils.toTimestamp(updateDate));
      map.put("approveDate", BocpGenUtils.toTimestamp(approveDate));
      map.put("poCancelDate", BocpGenUtils.toTimestamp(poCancelDate));
      map.put("totalAmt", totalAmt);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("documentStatus", documentStatus);
      map.put("cancelFlag", cancelFlag);
      map.put("approveType", approveType);
      map.put("discountTotalAmt", discountTotalAmt);
      map.put("discountRate", discountRate);
      map.put("promtFlag", promtFlag);
      map.put("promtPeriod", promtPeriod);
      map.put("promtType", promtType);
      map.put("shipMethod", shipMethod);
      map.put("logisticsMode", logisticsMode);
      map.put("shipType", shipType);
      map.put("deliveryFactoryCode", deliveryFactoryCode);
      map.put("deliveryFactoryName", deliveryFactoryName);
      map.put("deliveryShipperCode", deliveryShipperCode);
      map.put("deliveryShipperName", deliveryShipperName);
      map.put("warehouseManagersCode", warehouseManagersCode);
      map.put("warehouseManagersName", warehouseManagersName);
      map.put("sellerShipAddress", sellerShipAddress);
      map.put("scheduleDeliveryDate", BocpGenUtils.toTimestamp(scheduleDeliveryDate));
      map.put("deliveryDate", BocpGenUtils.toTimestamp(deliveryDate));
      map.put("receiveDate", BocpGenUtils.toTimestamp(receiveDate));
      map.put("currencyCode", currencyCode);
      map.put("currency", currency);
      map.put("exRateDate", BocpGenUtils.toTimestamp(exRateDate));
      map.put("exRate", exRate);
      map.put("exRateType", exRateType);
      map.put("settlementOrgCode", settlementOrgCode);
      map.put("settlementOrgName", settlementOrgName);
      map.put("settlementCode", settlementCode);
      map.put("settlementName", settlementName);
      map.put("payType", payType);
      map.put("payCondtCode", payCondtCode);
      map.put("payCondt", payCondt);
      map.put("payDiscount", payDiscount);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("businessId", businessId);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("latest", latest);
      map.put("pBusinessId", pBusinessId);
      map.put("pSellerDocStatus", pSellerDocStatus);
      map.put("pSellerInvoiceStatus", pSellerInvoiceStatus);
      map.put("pSellerReconStatus", pSellerReconStatus);

      return map;
  }

  public static SalesOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesOrder entity = new SalesOrder();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToGLN")) {
      Object obj = map.get("shipToGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveAddress")) {
      Object obj = map.get("receiveAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveContactPerson")) {
      Object obj = map.get("receiveContactPerson");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveContactPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseFax")) {
      Object obj = map.get("purchaseFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseEmail")) {
      Object obj = map.get("purchaseEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdByCode")) {
      Object obj = map.get("createdByCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatedByCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdByName")) {
      Object obj = map.get("createdByName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatedByName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonCode")) {
      Object obj = map.get("salesPersonCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesPersonCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonName")) {
      Object obj = map.get("salesPersonName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesPersonName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerPhone")) {
      Object obj = map.get("sellerPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerFax")) {
      Object obj = map.get("sellerFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerEmail")) {
      Object obj = map.get("sellerEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufacturerName")) {
      Object obj = map.get("manufacturerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManufacturerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufacturerCode")) {
      Object obj = map.get("manufacturerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManufacturerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDeliveryNo")) {
      Object obj = map.get("salesDeliveryNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesDeliveryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrdNo")) {
      Object obj = map.get("salesOrdNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("associatedPOId")) {
      Object obj = map.get("associatedPOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssociatedPOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("associatedPONo")) {
      Object obj = map.get("associatedPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssociatedPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("associatedBillNo")) {
      Object obj = map.get("associatedBillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssociatedBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseDate")) {
      Object obj = map.get("purchaseDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPurchaseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPurchaseDate(null);
      }
    }
    if(map.containsKey("purchaseRequestDate")) {
      Object obj = map.get("purchaseRequestDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPurchaseRequestDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPurchaseRequestDate(null);
      }
    }
    if(map.containsKey("salesContractNo")) {
      Object obj = map.get("salesContractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesContractLineNo")) {
      Object obj = map.get("salesContractLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesContractLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesMethod")) {
      Object obj = map.get("salesMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDate")) {
      Object obj = map.get("salesDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSalesDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSalesDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApproveDate(null);
      }
    }
    if(map.containsKey("poCancelDate")) {
      Object obj = map.get("poCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPoCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoCancelDate(null);
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCancelFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approveType")) {
      Object obj = map.get("approveType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApproveType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtPeriod")) {
      Object obj = map.get("promtPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtType")) {
      Object obj = map.get("promtType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipType")) {
      Object obj = map.get("shipType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryFactoryCode")) {
      Object obj = map.get("deliveryFactoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryFactoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryFactoryName")) {
      Object obj = map.get("deliveryFactoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryFactoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryShipperCode")) {
      Object obj = map.get("deliveryShipperCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryShipperCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryShipperName")) {
      Object obj = map.get("deliveryShipperName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryShipperName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseManagersCode")) {
      Object obj = map.get("warehouseManagersCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseManagersCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseManagersName")) {
      Object obj = map.get("warehouseManagersName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseManagersName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerShipAddress")) {
      Object obj = map.get("sellerShipAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerShipAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scheduleDeliveryDate")) {
      Object obj = map.get("scheduleDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setScheduleDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScheduleDeliveryDate(null);
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryDate(null);
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiveDate(null);
      }
    }
    if(map.containsKey("currencyCode")) {
      Object obj = map.get("currencyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrencyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgCode")) {
      Object obj = map.get("settlementOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgName")) {
      Object obj = map.get("settlementOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondt")) {
      Object obj = map.get("payCondt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payDiscount")) {
      Object obj = map.get("payDiscount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerDocStatus")) {
      Object obj = map.get("pSellerDocStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerDocStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerReconStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToGLN")) {
      Object obj = map.get("shipToGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveAddress")) {
      Object obj = map.get("receiveAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveContactPerson")) {
      Object obj = map.get("receiveContactPerson");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveContactPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchasePhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseFax")) {
      Object obj = map.get("purchaseFax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseFax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseEmail")) {
      Object obj = map.get("purchaseEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createdByCode")) {
      Object obj = map.get("createdByCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatedByCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createdByName")) {
      Object obj = map.get("createdByName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatedByName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesPersonCode")) {
      Object obj = map.get("salesPersonCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesPersonCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesPersonName")) {
      Object obj = map.get("salesPersonName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesPersonName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerPhone")) {
      Object obj = map.get("sellerPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerFax")) {
      Object obj = map.get("sellerFax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerFax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerEmail")) {
      Object obj = map.get("sellerEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manufacturerName")) {
      Object obj = map.get("manufacturerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManufacturerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manufacturerCode")) {
      Object obj = map.get("manufacturerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManufacturerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesDeliveryNo")) {
      Object obj = map.get("salesDeliveryNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesDeliveryNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrdNo")) {
      Object obj = map.get("salesOrdNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrdNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("associatedPOId")) {
      Object obj = map.get("associatedPOId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssociatedPOId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("associatedPONo")) {
      Object obj = map.get("associatedPONo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssociatedPONo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("associatedBillNo")) {
      Object obj = map.get("associatedBillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssociatedBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseDate")) {
      Object obj = map.get("purchaseDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPurchaseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPurchaseDate(null);
      }
    }
    if(map.containsKey("purchaseRequestDate")) {
      Object obj = map.get("purchaseRequestDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPurchaseRequestDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPurchaseRequestDate(null);
      }
    }
    if(map.containsKey("salesContractNo")) {
      Object obj = map.get("salesContractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesContractLineNo")) {
      Object obj = map.get("salesContractLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesContractLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesMethod")) {
      Object obj = map.get("salesMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesDate")) {
      Object obj = map.get("salesDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSalesDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSalesDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSalesDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApproveDate(null);
      }
    }
    if(map.containsKey("poCancelDate")) {
      Object obj = map.get("poCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPoCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPoCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPoCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPoCancelDate(null);
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCancelFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approveType")) {
      Object obj = map.get("approveType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApproveType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromtFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("promtPeriod")) {
      Object obj = map.get("promtPeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromtPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("promtType")) {
      Object obj = map.get("promtType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromtType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipType")) {
      Object obj = map.get("shipType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryFactoryCode")) {
      Object obj = map.get("deliveryFactoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryFactoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryFactoryName")) {
      Object obj = map.get("deliveryFactoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryFactoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryShipperCode")) {
      Object obj = map.get("deliveryShipperCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryShipperCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryShipperName")) {
      Object obj = map.get("deliveryShipperName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryShipperName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseManagersCode")) {
      Object obj = map.get("warehouseManagersCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseManagersCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseManagersName")) {
      Object obj = map.get("warehouseManagersName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseManagersName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerShipAddress")) {
      Object obj = map.get("sellerShipAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerShipAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scheduleDeliveryDate")) {
      Object obj = map.get("scheduleDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setScheduleDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setScheduleDeliveryDate(null);
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeliveryDate(null);
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReceiveDate(null);
      }
    }
    if(map.containsKey("currencyCode")) {
      Object obj = map.get("currencyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrencyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExRateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementOrgCode")) {
      Object obj = map.get("settlementOrgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementOrgName")) {
      Object obj = map.get("settlementOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCondtCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCondt")) {
      Object obj = map.get("payCondt");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCondt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payDiscount")) {
      Object obj = map.get("payDiscount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayDiscount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSellerDocStatus")) {
      Object obj = map.get("pSellerDocStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerDocStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerReconStatus((String)obj);
        }
      } else {
      }
    }
  }
}
