package com.xforceplus.ultraman.app.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TenantTransferRecord implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 来源单据摘要
   */
  @TableField("sourceDocDesc")
  private String sourceDocDesc;

  /**
   * 目标单据摘要
   */
  @TableField("targetDocDesc")
  private String targetDocDesc;

  /**
   * 租户单据转换状态
   */
  @TableField("transferStatus")
  private String transferStatus;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商名称
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 来源单据号
   */
  @TableField("sourceDocNo")
  private String sourceDocNo;

  /**
   * 目标单据号
   */
  @TableField("targetDocNo")
  private String targetDocNo;

  /**
   * 转换时间
   */
  @TableField("transferTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime transferTime;

  /**
   * 来源单据版本号
   */
  @TableField("sourceDocVersion")
  private String sourceDocVersion;

  /**
   * 目标单据版本号
   */
  @TableField("targetDocVersion")
  private String targetDocVersion;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 错误信息
   */
  @TableField("errorMessage")
  private String errorMessage;

  /**
   * 流日志ID
   */
  @TableField("flowLogID")
  private String flowLogID;

  /**
   * 流ID
   */
  @TableField("flowID")
  private String flowID;

  /**
   * 转换明细
   */
  @TableField("transferDetail")
  private String transferDetail;

  /**
   * sqsID
   */
  @TableField("sqsID")
  private String sqsID;

  /**
   * 扩展字段
   */
  private String ext1;

  /**
   * 来源单据类型
   */
  @TableField("sourceDocType")
  private String sourceDocType;

  /**
   * 目标单据类型
   */
  @TableField("targetDocType")
  private String targetDocType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("sourceDocDesc", sourceDocDesc);
      map.put("targetDocDesc", targetDocDesc);
      map.put("transferStatus", transferStatus);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("sourceDocNo", sourceDocNo);
      map.put("targetDocNo", targetDocNo);
      map.put("transferTime", BocpGenUtils.toTimestamp(transferTime));
      map.put("sourceDocVersion", sourceDocVersion);
      map.put("targetDocVersion", targetDocVersion);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("errorMessage", errorMessage);
      map.put("flowLogID", flowLogID);
      map.put("flowID", flowID);
      map.put("transferDetail", transferDetail);
      map.put("sqsID", sqsID);
      map.put("ext1", ext1);
      map.put("sourceDocType", sourceDocType);
      map.put("targetDocType", targetDocType);

      return map;
  }

  public static TenantTransferRecord fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TenantTransferRecord entity = new TenantTransferRecord();
    if(map.containsKey("sourceDocDesc")) {
      Object obj = map.get("sourceDocDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetDocDesc")) {
      Object obj = map.get("targetDocDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetDocDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferStatus")) {
      Object obj = map.get("transferStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransferStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceDocNo")) {
      Object obj = map.get("sourceDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetDocNo")) {
      Object obj = map.get("targetDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTransferTime(null);
      }
    }
    if(map.containsKey("sourceDocVersion")) {
      Object obj = map.get("sourceDocVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetDocVersion")) {
      Object obj = map.get("targetDocVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetDocVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowLogID")) {
      Object obj = map.get("flowLogID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowLogID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowID")) {
      Object obj = map.get("flowID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferDetail")) {
      Object obj = map.get("transferDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransferDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqsID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceDocType")) {
      Object obj = map.get("sourceDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetDocType")) {
      Object obj = map.get("targetDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetDocType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("sourceDocDesc")) {
      Object obj = map.get("sourceDocDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetDocDesc")) {
      Object obj = map.get("targetDocDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetDocDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferStatus")) {
      Object obj = map.get("transferStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransferStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceDocNo")) {
      Object obj = map.get("sourceDocNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetDocNo")) {
      Object obj = map.get("targetDocNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetDocNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTransferTime(null);
      }
    }
    if(map.containsKey("sourceDocVersion")) {
      Object obj = map.get("sourceDocVersion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetDocVersion")) {
      Object obj = map.get("targetDocVersion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetDocVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowLogID")) {
      Object obj = map.get("flowLogID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowLogID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowID")) {
      Object obj = map.get("flowID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferDetail")) {
      Object obj = map.get("transferDetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransferDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqsID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceDocType")) {
      Object obj = map.get("sourceDocType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetDocType")) {
      Object obj = map.get("targetDocType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetDocType((String)obj);
        }
      } else {
      }
    }
  }
}
