package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * page_element_name
 * </p>
 *
 * @author ultraman
 * @since 2023-12-05
 */
public enum PageElementName {

    MAIN_TABLE_HEADER("MAIN_TABLE_HEADER", "主要表单字段"),
    BUTTON("BUTTON", "按钮字段");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PageElementName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PageElementName fromCode(String code){
        switch(code) {
            case "MAIN_TABLE_HEADER":
                return MAIN_TABLE_HEADER;
            case "BUTTON":
                return BUTTON;
            default:
                return null;
        }
    }
}
