package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-12-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExpenseSettlementDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 序号
   */
  @TableField("lineNo")
  private String lineNo;

  /**
   * 费用单号
   */
  @TableField("expenseDocumentNo")
  private String expenseDocumentNo;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 费用单类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 费用单类型名称
   */
  @TableField("documentTypeName")
  private String documentTypeName;

  /**
   * 账扣票扣类型
   */
  @TableField("deductionType")
  private String deductionType;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 费用代码
   */
  @TableField("expenseType")
  private String expenseType;

  /**
   * 费用名称
   */
  @TableField("expenseName")
  private String expenseName;

  /**
   * 费用金额（含税）
   */
  @TableField("expenseAmtWithTax")
  private BigDecimal expenseAmtWithTax;

  /**
   * 费用金额（不含税）
   */
  @TableField("expenseAmtWithoutTax")
  private BigDecimal expenseAmtWithoutTax;

  /**
   * 费用说明
   */
  @TableField("expenseDesc")
  private String expenseDesc;

  /**
   * 业务发生日期
   */
  @TableField("businessOccurrenceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessOccurrenceDate;

  /**
   * 结算日期
   */
  @TableField("settlementDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementDate;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算单子单号
   */
  @TableField("settlementSubNo")
  private String settlementSubNo;

  /**
   * 手工单号
   */
  @TableField("manualDocumentNo")
  private String manualDocumentNo;

  /**
   * 来源往期结算单号
   */
  @TableField("previousSettlementNo")
  private String previousSettlementNo;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 关联商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 业务Id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 结算单编号
   */
  @TableField("settlementNo")
  private String settlementNo;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 费用税额
   */
  @TableField("expenseTaxAmt")
  private BigDecimal expenseTaxAmt;

  /**
   * 销售金额（含税）
   */
  @TableField("salesAmtWithTax")
  private BigDecimal salesAmtWithTax;

  /**
   * 销售金额（不含税）
   */
  @TableField("salesAmtWithoutTax")
  private BigDecimal salesAmtWithoutTax;

  /**
   * 采购日期
   */
  @TableField("poDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poDate;

  /**
   * 付款方式
   */
  @TableField("paymentMethod")
  private String paymentMethod;

  /**
   * 协议单号
   */
  @TableField("protocolNo")
  private String protocolNo;

  /**
   * 品类编码
   */
  @TableField("categoryCode")
  private String categoryCode;

  /**
   * 品类名称
   */
  @TableField("categoryDesc")
  private String categoryDesc;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 规格
   */
  private String standards;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 单据单位
   */
  private String unit;

  /**
   * 单据数量
   */
  private BigDecimal qty;

  /**
   * 备注
   */
  private String remark;

  /**
   * 是否最新
   */
  private Boolean latest;

  /**
   * 业务id
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * 业态编码
   */
  @TableField("purchaseBusinessTypeNo")
  private String purchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  @TableField("purchaseBusinessTypeName")
  private String purchaseBusinessTypeName;

  /**
   * 批次号
   */
  @TableField("batchNumberOD2UD")
  private String batchNumberOD2UD;

  /**
   * 系统单据来源类型
   */
  @TableField("pSysSourceType")
  private String pSysSourceType;

  /**
   * 系统单据编号
   */
  @TableField("pSysNo")
  private String pSysNo;

  /**
   * 费用单汇总金额（含税）
   */
  @TableField("expSumAmtWithTax")
  private BigDecimal expSumAmtWithTax;

  /**
   * 费用单汇总金额（不含税）
   */
  @TableField("expSumAmtWithoutTax")
  private BigDecimal expSumAmtWithoutTax;

  /**
   * 费用单汇总税额
   */
  @TableField("expSumTaxAmt")
  private BigDecimal expSumTaxAmt;

  /**
   * 结算单汇总金额（含税）
   */
  @TableField("settlementSumAmtWithTax")
  private BigDecimal settlementSumAmtWithTax;

  /**
   * 结算单汇总金额（不含税）
   */
  @TableField("settlementSumAmtWithoutTax")
  private BigDecimal settlementSumAmtWithoutTax;

  /**
   * 结算单汇总税额
   */
  @TableField("settlementSumTaxAmt")
  private BigDecimal settlementSumTaxAmt;

  /**
   * 付款单汇总金额（含税）
   */
  @TableField("paySumAmtWithTax")
  private BigDecimal paySumAmtWithTax;

  /**
   * 付款单汇总金额（不含税）
   */
  @TableField("paySumAmtWithoutTax")
  private BigDecimal paySumAmtWithoutTax;

  /**
   * 付款单汇总税额
   */
  @TableField("paySumTaxAmt")
  private BigDecimal paySumTaxAmt;


  /**
   * 对一关联关系 关联对象 settlementBill
   */
    private Long expenseIdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("expenseDocumentNo", expenseDocumentNo);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("documentType", documentType);
      map.put("documentTypeName", documentTypeName);
      map.put("deductionType", deductionType);
      map.put("taxRate", taxRate);
      map.put("expenseType", expenseType);
      map.put("expenseName", expenseName);
      map.put("expenseAmtWithTax", expenseAmtWithTax);
      map.put("expenseAmtWithoutTax", expenseAmtWithoutTax);
      map.put("expenseDesc", expenseDesc);
      map.put("businessOccurrenceDate", BocpGenUtils.toTimestamp(businessOccurrenceDate));
      map.put("settlementDate", BocpGenUtils.toTimestamp(settlementDate));
      map.put("contractNo", contractNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("settlementSubNo", settlementSubNo);
      map.put("manualDocumentNo", manualDocumentNo);
      map.put("previousSettlementNo", previousSettlementNo);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("pBusinessId", pBusinessId);
      map.put("versionNo", versionNo);
      map.put("settlementNo", settlementNo);
      map.put("paymentNo", paymentNo);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("expenseTaxAmt", expenseTaxAmt);
      map.put("salesAmtWithTax", salesAmtWithTax);
      map.put("salesAmtWithoutTax", salesAmtWithoutTax);
      map.put("poDate", BocpGenUtils.toTimestamp(poDate));
      map.put("paymentMethod", paymentMethod);
      map.put("protocolNo", protocolNo);
      map.put("categoryCode", categoryCode);
      map.put("categoryDesc", categoryDesc);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemDesc", itemDesc);
      map.put("standards", standards);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("unit", unit);
      map.put("qty", qty);
      map.put("remark", remark);
      map.put("latest", latest);
      map.put("businessId", businessId);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("batchNumberOD2UD", batchNumberOD2UD);
      map.put("pSysSourceType", pSysSourceType);
      map.put("pSysNo", pSysNo);
      map.put("expSumAmtWithTax", expSumAmtWithTax);
      map.put("expSumAmtWithoutTax", expSumAmtWithoutTax);
      map.put("expSumTaxAmt", expSumTaxAmt);
      map.put("settlementSumAmtWithTax", settlementSumAmtWithTax);
      map.put("settlementSumAmtWithoutTax", settlementSumAmtWithoutTax);
      map.put("settlementSumTaxAmt", settlementSumTaxAmt);
      map.put("paySumAmtWithTax", paySumAmtWithTax);
      map.put("paySumAmtWithoutTax", paySumAmtWithoutTax);
      map.put("paySumTaxAmt", paySumTaxAmt);

       map.put("expenseId.id", expenseIdId);
      return map;
  }

  public static ExpenseSettlementDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ExpenseSettlementDetail entity = new ExpenseSettlementDetail();
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseDocumentNo")) {
      Object obj = map.get("expenseDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deductionType")) {
      Object obj = map.get("deductionType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeductionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseType")) {
      Object obj = map.get("expenseType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseName")) {
      Object obj = map.get("expenseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseAmtWithTax")) {
      Object obj = map.get("expenseAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpenseAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseAmtWithoutTax")) {
      Object obj = map.get("expenseAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpenseAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseDesc")) {
      Object obj = map.get("expenseDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessOccurrenceDate")) {
      Object obj = map.get("businessOccurrenceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBusinessOccurrenceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessOccurrenceDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementDate(null);
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementSubNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManualDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousSettlementNo")) {
      Object obj = map.get("previousSettlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreviousSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseTaxAmt")) {
      Object obj = map.get("expenseTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpenseTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithTax")) {
      Object obj = map.get("salesAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithoutTax")) {
      Object obj = map.get("salesAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoDate(null);
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("protocolNo")) {
      Object obj = map.get("protocolNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProtocolNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumberOD2UD((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysSourceType")) {
      Object obj = map.get("pSysSourceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysSourceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expSumAmtWithTax")) {
      Object obj = map.get("expSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expSumAmtWithoutTax")) {
      Object obj = map.get("expSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expSumTaxAmt")) {
      Object obj = map.get("expSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementSumAmtWithTax")) {
      Object obj = map.get("settlementSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementSumAmtWithoutTax")) {
      Object obj = map.get("settlementSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementSumTaxAmt")) {
      Object obj = map.get("settlementSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paySumAmtWithTax")) {
      Object obj = map.get("paySumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaySumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaySumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaySumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaySumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaySumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paySumAmtWithoutTax")) {
      Object obj = map.get("paySumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaySumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaySumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaySumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaySumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaySumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paySumTaxAmt")) {
      Object obj = map.get("paySumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaySumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaySumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaySumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaySumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaySumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    if(map.containsKey("expenseId.id")) {
        Object obj = map.get("expenseId.id");
      if(obj instanceof Long) {
        entity.setExpenseIdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setExpenseIdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseDocumentNo")) {
      Object obj = map.get("expenseDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deductionType")) {
      Object obj = map.get("deductionType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeductionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseType")) {
      Object obj = map.get("expenseType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseName")) {
      Object obj = map.get("expenseName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseAmtWithTax")) {
      Object obj = map.get("expenseAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseAmtWithoutTax")) {
      Object obj = map.get("expenseAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseDesc")) {
      Object obj = map.get("expenseDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessOccurrenceDate")) {
      Object obj = map.get("businessOccurrenceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBusinessOccurrenceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBusinessOccurrenceDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSettlementDate(null);
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementSubNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManualDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("previousSettlementNo")) {
      Object obj = map.get("previousSettlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreviousSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseTaxAmt")) {
      Object obj = map.get("expenseTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesAmtWithTax")) {
      Object obj = map.get("salesAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesAmtWithoutTax")) {
      Object obj = map.get("salesAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPoDate(null);
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("protocolNo")) {
      Object obj = map.get("protocolNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProtocolNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumberOD2UD((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSysSourceType")) {
      Object obj = map.get("pSysSourceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSysSourceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSysNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expSumAmtWithTax")) {
      Object obj = map.get("expSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expSumAmtWithoutTax")) {
      Object obj = map.get("expSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expSumTaxAmt")) {
      Object obj = map.get("expSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlementSumAmtWithTax")) {
      Object obj = map.get("settlementSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlementSumAmtWithoutTax")) {
      Object obj = map.get("settlementSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlementSumTaxAmt")) {
      Object obj = map.get("settlementSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paySumAmtWithTax")) {
      Object obj = map.get("paySumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaySumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaySumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaySumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaySumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaySumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paySumAmtWithoutTax")) {
      Object obj = map.get("paySumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaySumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaySumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaySumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaySumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaySumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paySumTaxAmt")) {
      Object obj = map.get("paySumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaySumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaySumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaySumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaySumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaySumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
      if(map.containsKey("expenseId.id")) {
        Object obj = map.get("expenseId.id");
        if(obj instanceof Long) {
          this.setExpenseIdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseIdId(Long.parseLong((String)obj));
        }
      }
  }
}
