package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_category
 * </p>
 *
 * @author ultraman
 * @since 2023-12-08
 */
public enum DocumentCategory {

    GRN("GRN", "收货单"),
    RTV("RTV", "退货单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocumentCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentCategory fromCode(String code){
        switch(code) {
            case "GRN":
                return GRN;
            case "RTV":
                return RTV;
            default:
                return null;
        }
    }
}
