package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * capture_method
 * </p>
 *
 * @author ultraman
 * @since 2024-01-25
 */
public enum CaptureMethod {

    WEBPAGE("WEBPAGE", "网页采集"),
    API("API", "接口采集"),
    FILE("FILE", "文件采集");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CaptureMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CaptureMethod fromCode(String code){
        switch(code) {
            case "WEBPAGE":
                return WEBPAGE;
            case "API":
                return API;
            case "FILE":
                return FILE;
            default:
                return null;
        }
    }
}
