package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-01-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TenantSalesOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 关联商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 业务Id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 客户类型
   */
  @TableField("customerType")
  private String customerType;

  /**
   * 客户编码
   */
  @TableField("customerCode")
  private String customerCode;

  /**
   * 客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 售达方编码
   */
  @TableField("soldToCode")
  private String soldToCode;

  /**
   * 售达方名称
   */
  @TableField("soldToName")
  private String soldToName;

  /**
   * 送达方编码
   */
  @TableField("shipToCode")
  private String shipToCode;

  /**
   * 送达方GLN
   */
  @TableField("shipToGLN")
  private String shipToGLN;

  /**
   * 送达方名称
   */
  @TableField("shipToName")
  private String shipToName;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 购方门店地址
   */
  @TableField("purchaseStoreAddress")
  private String purchaseStoreAddress;

  /**
   * 收货地址
   */
  @TableField("receiveAddress")
  private String receiveAddress;

  /**
   * 收货联系人
   */
  @TableField("receiveContactPerson")
  private String receiveContactPerson;

  /**
   * 购方联系电话
   */
  @TableField("purchasePhone")
  private String purchasePhone;

  /**
   * 购方传真
   */
  @TableField("purchaseFax")
  private String purchaseFax;

  /**
   * 购方邮箱
   */
  @TableField("purchaseEmail")
  private String purchaseEmail;

  /**
   * 销方类型
   */
  @TableField("sellerType")
  private String sellerType;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 销方公司编码
   */
  @TableField("sellerCompanyCode")
  private String sellerCompanyCode;

  /**
   * 销方公司名称
   */
  @TableField("sellerCompanyName")
  private String sellerCompanyName;

  /**
   * 业务单元编码
   */
  @TableField("buCode")
  private String buCode;

  /**
   * 业务单元名称
   */
  @TableField("buName")
  private String buName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销售组织编码
   */
  @TableField("salesOrganizationCode")
  private String salesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("salesOrganizationName")
  private String salesOrganizationName;

  /**
   * 销售部门编码
   */
  @TableField("salesDepartmentCode")
  private String salesDepartmentCode;

  /**
   * 销售部门名称
   */
  @TableField("salesDepartmentName")
  private String salesDepartmentName;

  /**
   * 产品组编码
   */
  @TableField("divisionCode")
  private String divisionCode;

  /**
   * 产品组名称
   */
  @TableField("divisionName")
  private String divisionName;

  /**
   * 分销渠道编码
   */
  @TableField("distributionChannelCode")
  private String distributionChannelCode;

  /**
   * 分销渠道名称
   */
  @TableField("distributionChannelName")
  private String distributionChannelName;

  /**
   * 制单员编码
   */
  @TableField("createdByCode")
  private String createdByCode;

  /**
   * 制单员
   */
  @TableField("createdByName")
  private String createdByName;

  /**
   * 销售员编码
   */
  @TableField("salesPersonCode")
  private String salesPersonCode;

  /**
   * 销售员
   */
  @TableField("salesPersonName")
  private String salesPersonName;

  /**
   * 销方联系电话
   */
  @TableField("sellerPhone")
  private String sellerPhone;

  /**
   * 销方传真
   */
  @TableField("sellerFax")
  private String sellerFax;

  /**
   * 销方邮箱
   */
  @TableField("sellerEmail")
  private String sellerEmail;

  /**
   * 销售订单号
   */
  @TableField("salesOrdNo")
  private String salesOrdNo;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 关联处采购订单ID
   */
  @TableField("associatedPOID")
  private String associatedPOID;

  /**
   * 关联采购订单编号
   */
  @TableField("associatedPONo")
  private String associatedPONo;

  /**
   * 关联单据编码
   */
  @TableField("associatedBillNo")
  private String associatedBillNo;

  /**
   * 采购订单日期
   */
  @TableField("purchaseDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime purchaseDate;

  /**
   * 采购请求交货日期
   */
  @TableField("purchaseRequestDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime purchaseRequestDate;

  /**
   * 采购订单备注
   */
  @TableField("poRemark")
  private String poRemark;

  /**
   * 销售合同号
   */
  @TableField("salesContractNo")
  private String salesContractNo;

  /**
   * 销售合同行号
   */
  @TableField("salesContractLineNo")
  private String salesContractLineNo;

  /**
   * 销售方式
   */
  @TableField("salesMethod")
  private String salesMethod;

  /**
   * 订单平台类型
   */
  @TableField("platformSoType")
  private String platformSoType;

  /**
   * 销售订单类型
   */
  @TableField("soType")
  private String soType;

  /**
   * 单据日期
   */
  @TableField("documentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;

  /**
   * 创建日期
   */
  @TableField("creationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;

  /**
   * 更新日期
   */
  @TableField("updateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateDate;

  /**
   * 审批日期
   */
  @TableField("approveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approveDate;

  /**
   * 取消日期
   */
  @TableField("poCancelDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poCancelDate;

  /**
   * 价格方式
   */
  @TableField("priceStatus")
  private Long priceStatus;

  /**
   * 总金额（含税）
   */
  @TableField("totalAmt")
  private BigDecimal totalAmt;

  /**
   * 总金额（不含税）
   */
  @TableField("totalAmtWithoutTax")
  private BigDecimal totalAmtWithoutTax;

  /**
   * 单据状态
   */
  @TableField("documentStatus")
  private String documentStatus;

  /**
   * 取消标识
   */
  @TableField("cancelFlag")
  private Long cancelFlag;

  /**
   * 审批类型
   */
  @TableField("approveType")
  private String approveType;

  /**
   * 折扣总金额（含税）
   */
  @TableField("discountTotalAmt")
  private BigDecimal discountTotalAmt;

  /**
   * 折扣总金额（不含税）
   */
  @TableField("discountTotalAmtWithoutTax")
  private BigDecimal discountTotalAmtWithoutTax;

  /**
   * 折扣率
   */
  @TableField("discountRate")
  private BigDecimal discountRate;

  /**
   * 是否促销
   */
  @TableField("promtFlag")
  private String promtFlag;

  /**
   * 促销期数
   */
  @TableField("promtPeriod")
  private String promtPeriod;

  /**
   * 促销类型
   */
  @TableField("promtType")
  private String promtType;

  /**
   * 发运方式
   */
  @TableField("shipMethod")
  private String shipMethod;

  /**
   * 物流模式
   */
  @TableField("logisticsMode")
  private String logisticsMode;

  /**
   * 发货类型
   */
  @TableField("shipType")
  private String shipType;

  /**
   * 交货工厂编码
   */
  @TableField("deliveryFactoryCode")
  private String deliveryFactoryCode;

  /**
   * 交货工厂名称
   */
  @TableField("deliveryFactoryName")
  private String deliveryFactoryName;

  /**
   * 发货人员编码
   */
  @TableField("deliveryShipperCode")
  private String deliveryShipperCode;

  /**
   * 发货人员
   */
  @TableField("deliveryShipperName")
  private String deliveryShipperName;

  /**
   * 仓管员编码
   */
  @TableField("warehouseManagersCode")
  private String warehouseManagersCode;

  /**
   * 仓管员
   */
  @TableField("warehouseManagersName")
  private String warehouseManagersName;

  /**
   * 发货地址
   */
  @TableField("sellerShipAddress")
  private String sellerShipAddress;

  /**
   * 计划发货日期
   */
  @TableField("scheduleDeliveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scheduleDeliveryDate;

  /**
   * 发货日期
   */
  @TableField("deliveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryDate;

  /**
   * 实际收货日期
   */
  @TableField("receiveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiveDate;

  /**
   * 币种
   */
  private String currency;

  /**
   * 汇率日期
   */
  @TableField("exRateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exRateDate;

  /**
   * 汇率
   */
  @TableField("exRate")
  private BigDecimal exRate;

  /**
   * 汇率类型
   */
  @TableField("exRateType")
  private String exRateType;

  /**
   * 结算财务组织编码
   */
  @TableField("settlementOrgCode")
  private String settlementOrgCode;

  /**
   * 结算财务组织名称
   */
  @TableField("settlementOrgName")
  private String settlementOrgName;

  /**
   * 销售凭证类型
   */
  @TableField("salesDocumentType")
  private String salesDocumentType;

  /**
   * 结算方式编码
   */
  @TableField("settlementCode")
  private String settlementCode;

  /**
   * 结算方式名称
   */
  @TableField("settlementName")
  private String settlementName;

  /**
   * 付款类型
   */
  @TableField("payType")
  private String payType;

  /**
   * 付款条件编码
   */
  @TableField("payCondtCode")
  private String payCondtCode;

  /**
   * 付款条件
   */
  @TableField("payCondt")
  private String payCondt;

  /**
   * 付款折扣
   */
  @TableField("payDiscount")
  private String payDiscount;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 数字业务id
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * 是否最新版本
   */
  private Boolean latest;

  /**
   * 自定义字段1
   */
  private String attribute1;

  /**
   * 自定义字段2
   */
  private String attribute2;

  /**
   * 自定义字段3
   */
  private String attribute3;

  /**
   * 自定义字段4
   */
  private String attribute4;

  /**
   * 自定义字段5
   */
  private String attribute5;

  /**
   * 自定义字段6
   */
  private String attribute6;

  /**
   * 自定义字段7
   */
  private String attribute7;

  /**
   * 自定义字段8
   */
  private String attribute8;

  /**
   * PDF文件地址
   */
  @TableField("pdfURL")
  private String pdfURL;

  /**
   * PDF文件类型
   */
  @TableField("pdfFileType")
  private String pdfFileType;

  /**
   * 关联ERP销售订单ID
   */
  @TableField("erpSoID")
  private String erpSoID;

  /**
   * 关联ERP销售订单号
   */
  @TableField("erpSoNo")
  private String erpSoNo;

  /**
   * 被拆分标记
   */
  @TableField("pBeSplitFlag")
  private Boolean pBeSplitFlag;

  /**
   * 拆分单标记
   */
  @TableField("pSplitDocFlag")
  private Boolean pSplitDocFlag;

  /**
   * 关联被拆分单据ID
   */
  @TableField("pRefBeSplitDocId")
  private String pRefBeSplitDocId;

  /**
   * 关联被拆分单据编号
   */
  @TableField("pRefBeSplitDocNo")
  private String pRefBeSplitDocNo;

  /**
   * 单据检查实例ID
   */
  @TableField("pCheckInstanceID")
  private String pCheckInstanceID;

  /**
   * 单据检查标签
   */
  @TableField("pCheckTags")
  private String pCheckTags;

  /**
   * ERP传输状态
   */
  @TableField("erpTransmitStatus")
  private String erpTransmitStatus;

  /**
   * 租户单据检查状态
   */
  @TableField("pCheckStatus")
  private String pCheckStatus;

  /**
   * ERP销售订单状态
   */
  @TableField("erpSoStatus")
  private String erpSoStatus;

  /**
   * ERP销售订单状态描述
   */
  @TableField("erpSoStatusDesc")
  private String erpSoStatusDesc;

  /**
   * ERP传输时间
   */
  @TableField("erpTransmitTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime erpTransmitTime;

  /**
   * ERP反馈时间
   */
  @TableField("erpCallbackTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime erpCallbackTime;

  /**
   * ERP反馈信息
   */
  @TableField("erpCallbackMsg")
  private String erpCallbackMsg;

  /**
   * ERP传输状态
   */
  @TableField("erpCallbackStatus")
  private String erpCallbackStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("pBusinessId", pBusinessId);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("customerType", customerType);
      map.put("customerCode", customerCode);
      map.put("customerName", customerName);
      map.put("soldToCode", soldToCode);
      map.put("soldToName", soldToName);
      map.put("shipToCode", shipToCode);
      map.put("shipToGLN", shipToGLN);
      map.put("shipToName", shipToName);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("purchaseStoreAddress", purchaseStoreAddress);
      map.put("receiveAddress", receiveAddress);
      map.put("receiveContactPerson", receiveContactPerson);
      map.put("purchasePhone", purchasePhone);
      map.put("purchaseFax", purchaseFax);
      map.put("purchaseEmail", purchaseEmail);
      map.put("sellerType", sellerType);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("buCode", buCode);
      map.put("buName", buName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("salesOrganizationCode", salesOrganizationCode);
      map.put("salesOrganizationName", salesOrganizationName);
      map.put("salesDepartmentCode", salesDepartmentCode);
      map.put("salesDepartmentName", salesDepartmentName);
      map.put("divisionCode", divisionCode);
      map.put("divisionName", divisionName);
      map.put("distributionChannelCode", distributionChannelCode);
      map.put("distributionChannelName", distributionChannelName);
      map.put("createdByCode", createdByCode);
      map.put("createdByName", createdByName);
      map.put("salesPersonCode", salesPersonCode);
      map.put("salesPersonName", salesPersonName);
      map.put("sellerPhone", sellerPhone);
      map.put("sellerFax", sellerFax);
      map.put("sellerEmail", sellerEmail);
      map.put("salesOrdNo", salesOrdNo);
      map.put("versionNo", versionNo);
      map.put("associatedPOID", associatedPOID);
      map.put("associatedPONo", associatedPONo);
      map.put("associatedBillNo", associatedBillNo);
      map.put("purchaseDate", BocpGenUtils.toTimestamp(purchaseDate));
      map.put("purchaseRequestDate", BocpGenUtils.toTimestamp(purchaseRequestDate));
      map.put("poRemark", poRemark);
      map.put("salesContractNo", salesContractNo);
      map.put("salesContractLineNo", salesContractLineNo);
      map.put("salesMethod", salesMethod);
      map.put("platformSoType", platformSoType);
      map.put("soType", soType);
      map.put("documentDate", BocpGenUtils.toTimestamp(documentDate));
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("updateDate", BocpGenUtils.toTimestamp(updateDate));
      map.put("approveDate", BocpGenUtils.toTimestamp(approveDate));
      map.put("poCancelDate", BocpGenUtils.toTimestamp(poCancelDate));
      map.put("priceStatus", priceStatus);
      map.put("totalAmt", totalAmt);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("documentStatus", documentStatus);
      map.put("cancelFlag", cancelFlag);
      map.put("approveType", approveType);
      map.put("discountTotalAmt", discountTotalAmt);
      map.put("discountTotalAmtWithoutTax", discountTotalAmtWithoutTax);
      map.put("discountRate", discountRate);
      map.put("promtFlag", promtFlag);
      map.put("promtPeriod", promtPeriod);
      map.put("promtType", promtType);
      map.put("shipMethod", shipMethod);
      map.put("logisticsMode", logisticsMode);
      map.put("shipType", shipType);
      map.put("deliveryFactoryCode", deliveryFactoryCode);
      map.put("deliveryFactoryName", deliveryFactoryName);
      map.put("deliveryShipperCode", deliveryShipperCode);
      map.put("deliveryShipperName", deliveryShipperName);
      map.put("warehouseManagersCode", warehouseManagersCode);
      map.put("warehouseManagersName", warehouseManagersName);
      map.put("sellerShipAddress", sellerShipAddress);
      map.put("scheduleDeliveryDate", BocpGenUtils.toTimestamp(scheduleDeliveryDate));
      map.put("deliveryDate", BocpGenUtils.toTimestamp(deliveryDate));
      map.put("receiveDate", BocpGenUtils.toTimestamp(receiveDate));
      map.put("currency", currency);
      map.put("exRateDate", BocpGenUtils.toTimestamp(exRateDate));
      map.put("exRate", exRate);
      map.put("exRateType", exRateType);
      map.put("settlementOrgCode", settlementOrgCode);
      map.put("settlementOrgName", settlementOrgName);
      map.put("salesDocumentType", salesDocumentType);
      map.put("settlementCode", settlementCode);
      map.put("settlementName", settlementName);
      map.put("payType", payType);
      map.put("payCondtCode", payCondtCode);
      map.put("payCondt", payCondt);
      map.put("payDiscount", payDiscount);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("businessId", businessId);
      map.put("latest", latest);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("attribute3", attribute3);
      map.put("attribute4", attribute4);
      map.put("attribute5", attribute5);
      map.put("attribute6", attribute6);
      map.put("attribute7", attribute7);
      map.put("attribute8", attribute8);
      map.put("pdfURL", pdfURL);
      map.put("pdfFileType", pdfFileType);
      map.put("erpSoID", erpSoID);
      map.put("erpSoNo", erpSoNo);
      map.put("pBeSplitFlag", pBeSplitFlag);
      map.put("pSplitDocFlag", pSplitDocFlag);
      map.put("pRefBeSplitDocId", pRefBeSplitDocId);
      map.put("pRefBeSplitDocNo", pRefBeSplitDocNo);
      map.put("pCheckInstanceID", pCheckInstanceID);
      map.put("pCheckTags", pCheckTags);
      map.put("erpTransmitStatus", erpTransmitStatus);
      map.put("pCheckStatus", pCheckStatus);
      map.put("erpSoStatus", erpSoStatus);
      map.put("erpSoStatusDesc", erpSoStatusDesc);
      map.put("erpTransmitTime", BocpGenUtils.toTimestamp(erpTransmitTime));
      map.put("erpCallbackTime", BocpGenUtils.toTimestamp(erpCallbackTime));
      map.put("erpCallbackMsg", erpCallbackMsg);
      map.put("erpCallbackStatus", erpCallbackStatus);

      return map;
  }

  public static TenantSalesOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TenantSalesOrder entity = new TenantSalesOrder();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldToCode")) {
      Object obj = map.get("soldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldToName")) {
      Object obj = map.get("soldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToGLN")) {
      Object obj = map.get("shipToGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveAddress")) {
      Object obj = map.get("receiveAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveContactPerson")) {
      Object obj = map.get("receiveContactPerson");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveContactPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseFax")) {
      Object obj = map.get("purchaseFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseEmail")) {
      Object obj = map.get("purchaseEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buCode")) {
      Object obj = map.get("buCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buName")) {
      Object obj = map.get("buName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDepartmentCode")) {
      Object obj = map.get("salesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDepartmentName")) {
      Object obj = map.get("salesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("divisionCode")) {
      Object obj = map.get("divisionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("divisionName")) {
      Object obj = map.get("divisionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributionChannelCode")) {
      Object obj = map.get("distributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributionChannelName")) {
      Object obj = map.get("distributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdByCode")) {
      Object obj = map.get("createdByCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatedByCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdByName")) {
      Object obj = map.get("createdByName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatedByName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonCode")) {
      Object obj = map.get("salesPersonCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesPersonCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonName")) {
      Object obj = map.get("salesPersonName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesPersonName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerPhone")) {
      Object obj = map.get("sellerPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerFax")) {
      Object obj = map.get("sellerFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerEmail")) {
      Object obj = map.get("sellerEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrdNo")) {
      Object obj = map.get("salesOrdNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("associatedPOID")) {
      Object obj = map.get("associatedPOID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssociatedPOID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("associatedPONo")) {
      Object obj = map.get("associatedPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssociatedPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("associatedBillNo")) {
      Object obj = map.get("associatedBillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssociatedBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseDate")) {
      Object obj = map.get("purchaseDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPurchaseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPurchaseDate(null);
      }
    }
    if(map.containsKey("purchaseRequestDate")) {
      Object obj = map.get("purchaseRequestDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPurchaseRequestDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPurchaseRequestDate(null);
      }
    }
    if(map.containsKey("poRemark")) {
      Object obj = map.get("poRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesContractNo")) {
      Object obj = map.get("salesContractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesContractLineNo")) {
      Object obj = map.get("salesContractLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesContractLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesMethod")) {
      Object obj = map.get("salesMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platformSoType")) {
      Object obj = map.get("platformSoType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatformSoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soType")) {
      Object obj = map.get("soType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApproveDate(null);
      }
    }
    if(map.containsKey("poCancelDate")) {
      Object obj = map.get("poCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPoCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoCancelDate(null);
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCancelFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCancelFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCancelFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("approveType")) {
      Object obj = map.get("approveType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApproveType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmtWithoutTax")) {
      Object obj = map.get("discountTotalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtPeriod")) {
      Object obj = map.get("promtPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtType")) {
      Object obj = map.get("promtType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipType")) {
      Object obj = map.get("shipType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryFactoryCode")) {
      Object obj = map.get("deliveryFactoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryFactoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryFactoryName")) {
      Object obj = map.get("deliveryFactoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryFactoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryShipperCode")) {
      Object obj = map.get("deliveryShipperCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryShipperCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryShipperName")) {
      Object obj = map.get("deliveryShipperName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryShipperName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseManagersCode")) {
      Object obj = map.get("warehouseManagersCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseManagersCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseManagersName")) {
      Object obj = map.get("warehouseManagersName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseManagersName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerShipAddress")) {
      Object obj = map.get("sellerShipAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerShipAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scheduleDeliveryDate")) {
      Object obj = map.get("scheduleDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setScheduleDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScheduleDeliveryDate(null);
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryDate(null);
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiveDate(null);
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgCode")) {
      Object obj = map.get("settlementOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgName")) {
      Object obj = map.get("settlementOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDocumentType")) {
      Object obj = map.get("salesDocumentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondt")) {
      Object obj = map.get("payCondt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payDiscount")) {
      Object obj = map.get("payDiscount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfURL")) {
      Object obj = map.get("pdfURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfFileType")) {
      Object obj = map.get("pdfFileType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpSoID")) {
      Object obj = map.get("erpSoID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpSoID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpSoNo")) {
      Object obj = map.get("erpSoNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpSoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCheckInstanceID")) {
      Object obj = map.get("pCheckInstanceID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCheckInstanceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCheckTags")) {
      Object obj = map.get("pCheckTags");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCheckTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpTransmitStatus")) {
      Object obj = map.get("erpTransmitStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpTransmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCheckStatus")) {
      Object obj = map.get("pCheckStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpSoStatus")) {
      Object obj = map.get("erpSoStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpSoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpSoStatusDesc")) {
      Object obj = map.get("erpSoStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpSoStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpTransmitTime")) {
      Object obj = map.get("erpTransmitTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setErpTransmitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setErpTransmitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setErpTransmitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setErpTransmitTime(null);
      }
    }
    if(map.containsKey("erpCallbackTime")) {
      Object obj = map.get("erpCallbackTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setErpCallbackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setErpCallbackTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setErpCallbackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setErpCallbackTime(null);
      }
    }
    if(map.containsKey("erpCallbackMsg")) {
      Object obj = map.get("erpCallbackMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpCallbackMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpCallbackStatus")) {
      Object obj = map.get("erpCallbackStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpCallbackStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("soldToCode")) {
      Object obj = map.get("soldToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSoldToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("soldToName")) {
      Object obj = map.get("soldToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSoldToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToGLN")) {
      Object obj = map.get("shipToGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveAddress")) {
      Object obj = map.get("receiveAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveContactPerson")) {
      Object obj = map.get("receiveContactPerson");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveContactPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchasePhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseFax")) {
      Object obj = map.get("purchaseFax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseFax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseEmail")) {
      Object obj = map.get("purchaseEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buCode")) {
      Object obj = map.get("buCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buName")) {
      Object obj = map.get("buName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesDepartmentCode")) {
      Object obj = map.get("salesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesDepartmentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesDepartmentName")) {
      Object obj = map.get("salesDepartmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("divisionCode")) {
      Object obj = map.get("divisionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDivisionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("divisionName")) {
      Object obj = map.get("divisionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDivisionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distributionChannelCode")) {
      Object obj = map.get("distributionChannelCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistributionChannelCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distributionChannelName")) {
      Object obj = map.get("distributionChannelName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistributionChannelName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createdByCode")) {
      Object obj = map.get("createdByCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatedByCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createdByName")) {
      Object obj = map.get("createdByName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatedByName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesPersonCode")) {
      Object obj = map.get("salesPersonCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesPersonCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesPersonName")) {
      Object obj = map.get("salesPersonName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesPersonName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerPhone")) {
      Object obj = map.get("sellerPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerFax")) {
      Object obj = map.get("sellerFax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerFax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerEmail")) {
      Object obj = map.get("sellerEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrdNo")) {
      Object obj = map.get("salesOrdNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrdNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("associatedPOID")) {
      Object obj = map.get("associatedPOID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssociatedPOID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("associatedPONo")) {
      Object obj = map.get("associatedPONo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssociatedPONo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("associatedBillNo")) {
      Object obj = map.get("associatedBillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssociatedBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseDate")) {
      Object obj = map.get("purchaseDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPurchaseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPurchaseDate(null);
      }
    }
    if(map.containsKey("purchaseRequestDate")) {
      Object obj = map.get("purchaseRequestDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPurchaseRequestDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseRequestDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPurchaseRequestDate(null);
      }
    }
    if(map.containsKey("poRemark")) {
      Object obj = map.get("poRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesContractNo")) {
      Object obj = map.get("salesContractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesContractLineNo")) {
      Object obj = map.get("salesContractLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesContractLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesMethod")) {
      Object obj = map.get("salesMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platformSoType")) {
      Object obj = map.get("platformSoType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatformSoType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("soType")) {
      Object obj = map.get("soType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSoType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDocumentDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApproveDate(null);
      }
    }
    if(map.containsKey("poCancelDate")) {
      Object obj = map.get("poCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPoCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPoCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPoCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPoCancelDate(null);
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCancelFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCancelFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCancelFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("approveType")) {
      Object obj = map.get("approveType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApproveType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountTotalAmtWithoutTax")) {
      Object obj = map.get("discountTotalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromtFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("promtPeriod")) {
      Object obj = map.get("promtPeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromtPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("promtType")) {
      Object obj = map.get("promtType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromtType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipType")) {
      Object obj = map.get("shipType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryFactoryCode")) {
      Object obj = map.get("deliveryFactoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryFactoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryFactoryName")) {
      Object obj = map.get("deliveryFactoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryFactoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryShipperCode")) {
      Object obj = map.get("deliveryShipperCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryShipperCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryShipperName")) {
      Object obj = map.get("deliveryShipperName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryShipperName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseManagersCode")) {
      Object obj = map.get("warehouseManagersCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseManagersCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseManagersName")) {
      Object obj = map.get("warehouseManagersName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseManagersName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerShipAddress")) {
      Object obj = map.get("sellerShipAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerShipAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scheduleDeliveryDate")) {
      Object obj = map.get("scheduleDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setScheduleDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setScheduleDeliveryDate(null);
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeliveryDate(null);
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReceiveDate(null);
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExRateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementOrgCode")) {
      Object obj = map.get("settlementOrgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementOrgName")) {
      Object obj = map.get("settlementOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesDocumentType")) {
      Object obj = map.get("salesDocumentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCondtCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCondt")) {
      Object obj = map.get("payCondt");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCondt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payDiscount")) {
      Object obj = map.get("payDiscount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayDiscount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdfURL")) {
      Object obj = map.get("pdfURL");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfURL((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdfFileType")) {
      Object obj = map.get("pdfFileType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfFileType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpSoID")) {
      Object obj = map.get("erpSoID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpSoID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpSoNo")) {
      Object obj = map.get("erpSoNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpSoNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBeSplitDocId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBeSplitDocNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCheckInstanceID")) {
      Object obj = map.get("pCheckInstanceID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCheckInstanceID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCheckTags")) {
      Object obj = map.get("pCheckTags");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCheckTags((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpTransmitStatus")) {
      Object obj = map.get("erpTransmitStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpTransmitStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCheckStatus")) {
      Object obj = map.get("pCheckStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpSoStatus")) {
      Object obj = map.get("erpSoStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpSoStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpSoStatusDesc")) {
      Object obj = map.get("erpSoStatusDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpSoStatusDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpTransmitTime")) {
      Object obj = map.get("erpTransmitTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setErpTransmitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setErpTransmitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setErpTransmitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setErpTransmitTime(null);
      }
    }
    if(map.containsKey("erpCallbackTime")) {
      Object obj = map.get("erpCallbackTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setErpCallbackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setErpCallbackTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setErpCallbackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setErpCallbackTime(null);
      }
    }
    if(map.containsKey("erpCallbackMsg")) {
      Object obj = map.get("erpCallbackMsg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpCallbackMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpCallbackStatus")) {
      Object obj = map.get("erpCallbackStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpCallbackStatus((String)obj);
        }
      } else {
      }
    }
  }
}
