package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_type
 * </p>
 *
 * @author ultraman
 * @since 2024-02-27
 */
public enum DocumentType {

    PO("PO", "采购订单"),
    GRN("GRN", "收货单"),
    RTV("RTV", "退货单"),
    IR("IR", "库存"),
    POS("POS", "POS"),
    SO("SO", "销售订单"),
    BOS("BOS", "结算单"),
    BOP("BOP", "付款单"),
    BILLING("BILLING", "billing单"),
    ESD("ESD", "费用明细");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocumentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentType fromCode(String code){
        switch(code) {
            case "PO":
                return PO;
            case "GRN":
                return GRN;
            case "RTV":
                return RTV;
            case "IR":
                return IR;
            case "POS":
                return POS;
            case "SO":
                return SO;
            case "BOS":
                return BOS;
            case "BOP":
                return BOP;
            case "BILLING":
                return BILLING;
            case "ESD":
                return ESD;
            default:
                return null;
        }
    }
}
