package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_status
 * </p>
 *
 * @author ultraman
 * @since 2024-02-27
 */
public enum MatchStatus {

    WAITING("waiting", "待前序流程处理"),
    TO_BE_RECONCILED("toBeReconciled", "待对账"),
    RECONCILING("reconciling", "对账中"),
    RECONCILED("reconciled", "对账完成"),
    UNRECONCILED("unreconciled", "对账失效"),
    RECON_CONFIRMED("reconConfirmed", "对账确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatus fromCode(String code){
        switch(code) {
            case "waiting":
                return WAITING;
            case "toBeReconciled":
                return TO_BE_RECONCILED;
            case "reconciling":
                return RECONCILING;
            case "reconciled":
                return RECONCILED;
            case "unreconciled":
                return UNRECONCILED;
            case "reconConfirmed":
                return RECON_CONFIRMED;
            default:
                return null;
        }
    }
}
