package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-02-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MeituanPreferredProducts implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 省
   */
  private String province;

  /**
   * 市
   */
  private String city;

  /**
   * 地址
   */
  private String address;

  /**
   * 自提点名称
   */
  @TableField("selfLocation")
  private String selfLocation;

  /**
   * 商品获取方式
   */
  @TableField("itemAccess")
  private String itemAccess;

  /**
   * 搜索关键字
   */
  private String keywords;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 品名
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 生产日期
   */
  @TableField("manufactureDate")
  private String manufactureDate;

  /**
   * 口味
   */
  private String taste;

  /**
   * 价格
   */
  private BigDecimal price;

  /**
   * 优惠方式
   */
  @TableField("discountMethod")
  private String discountMethod;

  /**
   * 优惠价格
   */
  @TableField("favorablePrice")
  private BigDecimal favorablePrice;

  /**
   * 规格
   */
  private String standards;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 销量
   */
  @TableField("salesVolume")
  private Long salesVolume;

  /**
   * banner图
   */
  private String banner;

  /**
   * 商品详情
   */
  @TableField("itemDetails")
  private String itemDetails;

  /**
   * 评价数量
   */
  @TableField("evaluateNumber")
  private Long evaluateNumber;

  /**
   * 好评分数
   */
  @TableField("evaluateScore")
  private BigDecimal evaluateScore;

  /**
   * 好评标签
   */
  @TableField("evaluateTag")
  private String evaluateTag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("province", province);
      map.put("city", city);
      map.put("address", address);
      map.put("selfLocation", selfLocation);
      map.put("itemAccess", itemAccess);
      map.put("keywords", keywords);
      map.put("brand", brand);
      map.put("itemName", itemName);
      map.put("manufactureDate", manufactureDate);
      map.put("taste", taste);
      map.put("price", price);
      map.put("discountMethod", discountMethod);
      map.put("favorablePrice", favorablePrice);
      map.put("standards", standards);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesVolume", salesVolume);
      map.put("banner", banner);
      map.put("itemDetails", itemDetails);
      map.put("evaluateNumber", evaluateNumber);
      map.put("evaluateScore", evaluateScore);
      map.put("evaluateTag", evaluateTag);

      return map;
  }

  public static MeituanPreferredProducts fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MeituanPreferredProducts entity = new MeituanPreferredProducts();
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("selfLocation")) {
      Object obj = map.get("selfLocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSelfLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemAccess")) {
      Object obj = map.get("itemAccess");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemAccess((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keywords")) {
      Object obj = map.get("keywords");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKeywords((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufactureDate")) {
      Object obj = map.get("manufactureDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManufactureDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taste")) {
      Object obj = map.get("taste");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaste((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountMethod")) {
      Object obj = map.get("discountMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("favorablePrice")) {
      Object obj = map.get("favorablePrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFavorablePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFavorablePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFavorablePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFavorablePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFavorablePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesVolume")) {
      Object obj = map.get("salesVolume");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesVolume((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesVolume(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesVolume(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("banner")) {
      Object obj = map.get("banner");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBanner((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDetails")) {
      Object obj = map.get("itemDetails");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDetails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("evaluateNumber")) {
      Object obj = map.get("evaluateNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEvaluateNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEvaluateNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEvaluateNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("evaluateScore")) {
      Object obj = map.get("evaluateScore");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEvaluateScore((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEvaluateScore(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEvaluateScore(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEvaluateScore(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEvaluateScore(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("evaluateTag")) {
      Object obj = map.get("evaluateTag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEvaluateTag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("selfLocation")) {
      Object obj = map.get("selfLocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSelfLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemAccess")) {
      Object obj = map.get("itemAccess");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemAccess((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("keywords")) {
      Object obj = map.get("keywords");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKeywords((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manufactureDate")) {
      Object obj = map.get("manufactureDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManufactureDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taste")) {
      Object obj = map.get("taste");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaste((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountMethod")) {
      Object obj = map.get("discountMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("favorablePrice")) {
      Object obj = map.get("favorablePrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFavorablePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFavorablePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFavorablePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFavorablePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFavorablePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesVolume")) {
      Object obj = map.get("salesVolume");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSalesVolume((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesVolume(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesVolume(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("banner")) {
      Object obj = map.get("banner");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBanner((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDetails")) {
      Object obj = map.get("itemDetails");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDetails((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("evaluateNumber")) {
      Object obj = map.get("evaluateNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEvaluateNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEvaluateNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setEvaluateNumber(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("evaluateScore")) {
      Object obj = map.get("evaluateScore");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setEvaluateScore((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setEvaluateScore(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setEvaluateScore(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEvaluateScore(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setEvaluateScore(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("evaluateTag")) {
      Object obj = map.get("evaluateTag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEvaluateTag((String)obj);
        }
      } else {
      }
    }
  }
}
