package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * statistical_type
 * </p>
 *
 * @author ultraman
 * @since 2024-02-27
 */
public enum StatisticalType {

    DAY("Day", "日"),
    WEEK("Week", "周"),
    MONTH("Month", "月");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StatisticalType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StatisticalType fromCode(String code){
        switch(code) {
            case "Day":
                return DAY;
            case "Week":
                return WEEK;
            case "Month":
                return MONTH;
            default:
                return null;
        }
    }
}
