package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * support_status
 * </p>
 *
 * @author ultraman
 * @since 2024-02-27
 */
public enum SupportStatus {

    YES("YES", "已支持"),
    NO("NO", "不支持");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SupportStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SupportStatus fromCode(String code){
        switch(code) {
            case "YES":
                return YES;
            case "NO":
                return NO;
            default:
                return null;
        }
    }
}
