package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * warning_status
 * </p>
 *
 * @author ultraman
 * @since 2024-03-03
 */
public enum WarningStatus {

    Y("Y", "预警"),
    N("N", "不预警");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WarningStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WarningStatus fromCode(String code){
        switch(code) {
            case "Y":
                return Y;
            case "N":
                return N;
            default:
                return null;
        }
    }
}
