package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-03-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExpenseSettlementDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 序号
   */
  @TableField("lineNo")
  private String lineNo;

  /**
   * 费用单号
   */
  @TableField("expenseDocumentNo")
  private String expenseDocumentNo;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 费用单类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 费用单类型名称
   */
  @TableField("documentTypeName")
  private String documentTypeName;

  /**
   * 账扣票扣类型
   */
  @TableField("deductionType")
  private String deductionType;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 费用代码
   */
  @TableField("expenseType")
  private String expenseType;

  /**
   * 费用名称
   */
  @TableField("expenseName")
  private String expenseName;

  /**
   * 费用金额（含税）
   */
  @TableField("expenseAmtWithTax")
  private BigDecimal expenseAmtWithTax;

  /**
   * 费用金额（不含税）
   */
  @TableField("expenseAmtWithoutTax")
  private BigDecimal expenseAmtWithoutTax;

  /**
   * 费用说明
   */
  @TableField("expenseDesc")
  private String expenseDesc;

  /**
   * 业务发生日期
   */
  @TableField("businessOccurrenceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessOccurrenceDate;

  /**
   * 结算日期
   */
  @TableField("settlementDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementDate;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算单子单号
   */
  @TableField("settlementSubNo")
  private String settlementSubNo;

  /**
   * 手工单号
   */
  @TableField("manualDocumentNo")
  private String manualDocumentNo;

  /**
   * 来源往期结算单号
   */
  @TableField("previousSettlementNo")
  private String previousSettlementNo;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 关联商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 业务Id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 结算单编号
   */
  @TableField("settlementNo")
  private String settlementNo;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 费用税额
   */
  @TableField("expenseTaxAmt")
  private BigDecimal expenseTaxAmt;

  /**
   * 销售金额（含税）
   */
  @TableField("salesAmtWithTax")
  private BigDecimal salesAmtWithTax;

  /**
   * 销售金额（不含税）
   */
  @TableField("salesAmtWithoutTax")
  private BigDecimal salesAmtWithoutTax;

  /**
   * 采购日期
   */
  @TableField("poDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poDate;

  /**
   * 付款方式
   */
  @TableField("paymentMethod")
  private String paymentMethod;

  /**
   * 协议单号
   */
  @TableField("protocolNo")
  private String protocolNo;

  /**
   * 品类编码
   */
  @TableField("categoryCode")
  private String categoryCode;

  /**
   * 品类名称
   */
  @TableField("categoryDesc")
  private String categoryDesc;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 规格
   */
  private String standards;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 单据单位
   */
  private String unit;

  /**
   * 单据数量
   */
  private BigDecimal qty;

  /**
   * 备注
   */
  private String remark;

  /**
   * 是否最新
   */
  private Boolean latest;

  /**
   * 业务id
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * 业态编码
   */
  @TableField("purchaseBusinessTypeNo")
  private String purchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  @TableField("purchaseBusinessTypeName")
  private String purchaseBusinessTypeName;

  /**
   * 批次号
   */
  @TableField("batchNumberOD2UD")
  private String batchNumberOD2UD;

  /**
   * 系统单据来源类型
   */
  @TableField("pSysSourceType")
  private String pSysSourceType;

  /**
   * 系统单据编号
   */
  @TableField("pSysNo")
  private String pSysNo;

  /**
   * 费用单汇总金额（含税）
   */
  @TableField("expSumAmtWithTax")
  private BigDecimal expSumAmtWithTax;

  /**
   * 费用单汇总金额（不含税）
   */
  @TableField("expSumAmtWithoutTax")
  private BigDecimal expSumAmtWithoutTax;

  /**
   * 费用单汇总税额
   */
  @TableField("expSumTaxAmt")
  private BigDecimal expSumTaxAmt;

  /**
   * 结算单汇总金额（含税）
   */
  @TableField("settlementSumAmtWithTax")
  private BigDecimal settlementSumAmtWithTax;

  /**
   * 结算单汇总金额（不含税）
   */
  @TableField("settlementSumAmtWithoutTax")
  private BigDecimal settlementSumAmtWithoutTax;

  /**
   * 结算单汇总税额
   */
  @TableField("settlementSumTaxAmt")
  private BigDecimal settlementSumTaxAmt;

  /**
   * 付款单汇总金额（含税）
   */
  @TableField("paySumAmtWithTax")
  private BigDecimal paySumAmtWithTax;

  /**
   * 付款单汇总金额（不含税）
   */
  @TableField("paySumAmtWithoutTax")
  private BigDecimal paySumAmtWithoutTax;

  /**
   * 付款单汇总税额
   */
  @TableField("paySumTaxAmt")
  private BigDecimal paySumTaxAmt;

  /**
   * 销方版本号
   */
  @TableField("sVersionNo")
  private String sVersionNo;

  /**
   * 销方销售组编码
   */
  @TableField("sSalesGroupCode")
  private String sSalesGroupCode;

  /**
   * 销方销售组名称
   */
  @TableField("sSalesGroupName")
  private String sSalesGroupName;

  /**
   * 售达方编码
   */
  @TableField("sSoldToCode")
  private String sSoldToCode;

  /**
   * 售达方名称
   */
  @TableField("sSoldToName")
  private String sSoldToName;

  /**
   * 送达方编码
   */
  @TableField("sShipToCode")
  private String sShipToCode;

  /**
   * 送达方名称
   */
  @TableField("sShipToName")
  private String sShipToName;

  /**
   * 客户组编码
   */
  @TableField("sCustomerGroupCode")
  private String sCustomerGroupCode;

  /**
   * 客户组名称
   */
  @TableField("sCustomerGroupName")
  private String sCustomerGroupName;

  /**
   * 客户类型
   */
  @TableField("sCustomerType")
  private String sCustomerType;

  /**
   * 客户编码
   */
  @TableField("sCustomerCode")
  private String sCustomerCode;

  /**
   * 客户名称
   */
  @TableField("sCustomerName")
  private String sCustomerName;

  /**
   * 业务单元编码
   */
  @TableField("sBuCode")
  private String sBuCode;

  /**
   * 业务单元名称
   */
  @TableField("sBuName")
  private String sBuName;

  /**
   * 销售公司编码
   */
  @TableField("sCompanyCode")
  private String sCompanyCode;

  /**
   * 销售公司名称
   */
  @TableField("sCompanyName")
  private String sCompanyName;

  /**
   * 销售公司税号
   */
  @TableField("sCompanyTaxNo")
  private String sCompanyTaxNo;

  /**
   * 销售组织编码
   */
  @TableField("sSalesOrganizationCode")
  private String sSalesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("sSalesOrganizationName")
  private String sSalesOrganizationName;

  /**
   * 产品组编码
   */
  @TableField("sDivisionCode")
  private String sDivisionCode;

  /**
   * 产品组名称
   */
  @TableField("sDivisionName")
  private String sDivisionName;

  /**
   * 分销渠道编码
   */
  @TableField("sDistributionChannelCode")
  private String sDistributionChannelCode;

  /**
   * 分销渠道名称
   */
  @TableField("sDistributionChannelName")
  private String sDistributionChannelName;

  /**
   * 销售部门编码
   */
  @TableField("sSalesDepartmentCode")
  private String sSalesDepartmentCode;

  /**
   * 销售部门名称
   */
  @TableField("sSalesDepartmentName")
  private String sSalesDepartmentName;

  /**
   * 销方品类编码
   */
  @TableField("sCategoryCode")
  private String sCategoryCode;

  /**
   * 销方品类名称
   */
  @TableField("sCategoryDesc")
  private String sCategoryDesc;

  /**
   * 销方商品名称
   */
  @TableField("sItemDesc")
  private String sItemDesc;

  /**
   * 销方商品编码
   */
  @TableField("sItemCode")
  private String sItemCode;

  /**
   * 销方商品条码
   */
  @TableField("sBarcode")
  private String sBarcode;

  /**
   * 销方商品子编码
   */
  @TableField("sItemSubCode")
  private String sItemSubCode;

  /**
   * 销方重量单位
   */
  @TableField("sWeightUnit")
  private String sWeightUnit;

  /**
   * 销方总重量
   */
  @TableField("sTotalWeight")
  private String sTotalWeight;

  /**
   * 销方批量包装规格
   */
  @TableField("sPackageSize")
  private String sPackageSize;

  /**
   * 销方批量包装数量
   */
  @TableField("sPackageQty")
  private BigDecimal sPackageQty;

  /**
   * 销方批量包装单位
   */
  @TableField("sPackageUnit")
  private String sPackageUnit;

  /**
   * 销方批量包装单价（不含税）
   */
  @TableField("sPackageUnitPriceWithoutTax")
  private BigDecimal sPackageUnitPriceWithoutTax;

  /**
   * 销方批量包装单价（含税）
   */
  @TableField("sPackageUnitPriceWithTax")
  private BigDecimal sPackageUnitPriceWithTax;

  /**
   * 销方批量包装最小起订量
   */
  @TableField("sPackageMinOrdQty")
  private BigDecimal sPackageMinOrdQty;

  /**
   * 销方最小单位数量
   */
  @TableField("sStockKeepingQty")
  private BigDecimal sStockKeepingQty;

  /**
   * 销方最小单位单价（不含税）
   */
  @TableField("sStockKeepingPriceWithoutTax")
  private BigDecimal sStockKeepingPriceWithoutTax;

  /**
   * 销方最小单位单价（含税）
   */
  @TableField("sStockKeepingPriceWithTax")
  private BigDecimal sStockKeepingPriceWithTax;

  /**
   * 单位转换规则（对象数组）
   */
  @TableField("sUnitRules")
  private String sUnitRules;

  /**
   * 客户商品单位
   */
  @TableField("sCustomUnit")
  private String sCustomUnit;

  /**
   * 销方单据单位
   */
  @TableField("sUnit")
  private String sUnit;

  /**
   * 销方单据单位数量
   */
  @TableField("sQty")
  private BigDecimal sQty;

  /**
   * 销方单价（不含税）
   */
  @TableField("sUnitPriceWithoutTax")
  private BigDecimal sUnitPriceWithoutTax;

  /**
   * 销方单价（含税）
   */
  @TableField("sUnitPriceWithTax")
  private BigDecimal sUnitPriceWithTax;

  /**
   * 销方金额（含税）
   */
  @TableField("sAmountWithTax")
  private BigDecimal sAmountWithTax;

  /**
   * 销方金额（不含税）
   */
  @TableField("sAmountWithoutTax")
  private BigDecimal sAmountWithoutTax;

  /**
   * 销方税收分类
   */
  @TableField("sTaxType")
  private String sTaxType;

  /**
   * 销方税率
   */
  @TableField("sTaxRate")
  private BigDecimal sTaxRate;

  /**
   * 销方折扣率
   */
  @TableField("sDiscountRate")
  private BigDecimal sDiscountRate;

  /**
   * 销方是否促销
   */
  @TableField("sPromtFlag")
  private String sPromtFlag;

  /**
   * 销方是否赠品
   */
  @TableField("sFreeFlag")
  private String sFreeFlag;

  /**
   * 销方是否组套商品
   */
  @TableField("sSuitFlag")
  private String sSuitFlag;

  /**
   * 销方组套商品（数组）
   */
  @TableField("sSuitInfo")
  private String sSuitInfo;

  /**
   * 销方是否新老品
   */
  @TableField("sNewOldFlag")
  private String sNewOldFlag;

  /**
   * 销方新老商品（数组）
   */
  @TableField("sNewOldInfo")
  private String sNewOldInfo;

  /**
   * 销方最低起订量
   */
  @TableField("sMinOrdQty")
  private BigDecimal sMinOrdQty;

  /**
   * 自定义字段1
   */
  private String attribute1;

  /**
   * 自定义字段2
   */
  private String attribute2;

  /**
   * 自定义字段3
   */
  private String attribute3;

  /**
   * 自定义字段4
   */
  private String attribute4;

  /**
   * 自定义字段5
   */
  private String attribute5;

  /**
   * 统一单据标记
   */
  @TableField("pUnifyDocFlag")
  private Boolean pUnifyDocFlag;

  /**
   * 租户单据标记
   */
  @TableField("pTenantDocFlag")
  private Boolean pTenantDocFlag;

  /**
   * 被拆分标记
   */
  @TableField("pBeSplitFlag")
  private Boolean pBeSplitFlag;

  /**
   * 拆分单标记
   */
  @TableField("pSplitDocFlag")
  private Boolean pSplitDocFlag;

  /**
   * 关联被拆分单据ID
   */
  @TableField("pRefBeSplitDocId")
  private String pRefBeSplitDocId;

  /**
   * 关联被拆分单据编号
   */
  @TableField("pRefBeSplitDocNo")
  private String pRefBeSplitDocNo;

  /**
   * 关联被拆分行ID
   */
  @TableField("pRefBeSplitLineId")
  private String pRefBeSplitLineId;

  /**
   * 单据来源
   */
  @TableField("pSourceFrom")
  private String pSourceFrom;

  /**
   * 销方最小单位
   */
  @TableField("sStockKeepingUnit")
  private String sStockKeepingUnit;

  /**
   * 关联结算单奥特曼ID
   */
  @TableField("refSettlementHeadId")
  private String refSettlementHeadId;

  /**
   * 关联付款单奥特曼ID
   */
  @TableField("refPaymentHeadId")
  private String refPaymentHeadId;

  /**
   * 行业务ID
   */
  @TableField("pBusinessLineId")
  private String pBusinessLineId;

  /**
   * 行数据MD5
   */
  @TableField("pDataLineMD5")
  private String pDataLineMD5;

  /**
   * 删除标记
   */
  @TableField("pDeleteFlag")
  private Boolean pDeleteFlag;

  /**
   * 单据转换状态
   */
  @TableField("transState")
  private String transState;


  /**
   * 对一关联关系 关联对象 settlementBill
   */
    private Long expenseIdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("expenseDocumentNo", expenseDocumentNo);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("documentType", documentType);
      map.put("documentTypeName", documentTypeName);
      map.put("deductionType", deductionType);
      map.put("taxRate", taxRate);
      map.put("expenseType", expenseType);
      map.put("expenseName", expenseName);
      map.put("expenseAmtWithTax", expenseAmtWithTax);
      map.put("expenseAmtWithoutTax", expenseAmtWithoutTax);
      map.put("expenseDesc", expenseDesc);
      map.put("businessOccurrenceDate", BocpGenUtils.toTimestamp(businessOccurrenceDate));
      map.put("settlementDate", BocpGenUtils.toTimestamp(settlementDate));
      map.put("contractNo", contractNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("settlementSubNo", settlementSubNo);
      map.put("manualDocumentNo", manualDocumentNo);
      map.put("previousSettlementNo", previousSettlementNo);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("pBusinessId", pBusinessId);
      map.put("versionNo", versionNo);
      map.put("settlementNo", settlementNo);
      map.put("paymentNo", paymentNo);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("expenseTaxAmt", expenseTaxAmt);
      map.put("salesAmtWithTax", salesAmtWithTax);
      map.put("salesAmtWithoutTax", salesAmtWithoutTax);
      map.put("poDate", BocpGenUtils.toTimestamp(poDate));
      map.put("paymentMethod", paymentMethod);
      map.put("protocolNo", protocolNo);
      map.put("categoryCode", categoryCode);
      map.put("categoryDesc", categoryDesc);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemDesc", itemDesc);
      map.put("standards", standards);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("unit", unit);
      map.put("qty", qty);
      map.put("remark", remark);
      map.put("latest", latest);
      map.put("businessId", businessId);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("batchNumberOD2UD", batchNumberOD2UD);
      map.put("pSysSourceType", pSysSourceType);
      map.put("pSysNo", pSysNo);
      map.put("expSumAmtWithTax", expSumAmtWithTax);
      map.put("expSumAmtWithoutTax", expSumAmtWithoutTax);
      map.put("expSumTaxAmt", expSumTaxAmt);
      map.put("settlementSumAmtWithTax", settlementSumAmtWithTax);
      map.put("settlementSumAmtWithoutTax", settlementSumAmtWithoutTax);
      map.put("settlementSumTaxAmt", settlementSumTaxAmt);
      map.put("paySumAmtWithTax", paySumAmtWithTax);
      map.put("paySumAmtWithoutTax", paySumAmtWithoutTax);
      map.put("paySumTaxAmt", paySumTaxAmt);
      map.put("sVersionNo", sVersionNo);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("sSoldToCode", sSoldToCode);
      map.put("sSoldToName", sSoldToName);
      map.put("sShipToCode", sShipToCode);
      map.put("sShipToName", sShipToName);
      map.put("sCustomerGroupCode", sCustomerGroupCode);
      map.put("sCustomerGroupName", sCustomerGroupName);
      map.put("sCustomerType", sCustomerType);
      map.put("sCustomerCode", sCustomerCode);
      map.put("sCustomerName", sCustomerName);
      map.put("sBuCode", sBuCode);
      map.put("sBuName", sBuName);
      map.put("sCompanyCode", sCompanyCode);
      map.put("sCompanyName", sCompanyName);
      map.put("sCompanyTaxNo", sCompanyTaxNo);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);
      map.put("sDivisionCode", sDivisionCode);
      map.put("sDivisionName", sDivisionName);
      map.put("sDistributionChannelCode", sDistributionChannelCode);
      map.put("sDistributionChannelName", sDistributionChannelName);
      map.put("sSalesDepartmentCode", sSalesDepartmentCode);
      map.put("sSalesDepartmentName", sSalesDepartmentName);
      map.put("sCategoryCode", sCategoryCode);
      map.put("sCategoryDesc", sCategoryDesc);
      map.put("sItemDesc", sItemDesc);
      map.put("sItemCode", sItemCode);
      map.put("sBarcode", sBarcode);
      map.put("sItemSubCode", sItemSubCode);
      map.put("sWeightUnit", sWeightUnit);
      map.put("sTotalWeight", sTotalWeight);
      map.put("sPackageSize", sPackageSize);
      map.put("sPackageQty", sPackageQty);
      map.put("sPackageUnit", sPackageUnit);
      map.put("sPackageUnitPriceWithoutTax", sPackageUnitPriceWithoutTax);
      map.put("sPackageUnitPriceWithTax", sPackageUnitPriceWithTax);
      map.put("sPackageMinOrdQty", sPackageMinOrdQty);
      map.put("sStockKeepingQty", sStockKeepingQty);
      map.put("sStockKeepingPriceWithoutTax", sStockKeepingPriceWithoutTax);
      map.put("sStockKeepingPriceWithTax", sStockKeepingPriceWithTax);
      map.put("sUnitRules", sUnitRules);
      map.put("sCustomUnit", sCustomUnit);
      map.put("sUnit", sUnit);
      map.put("sQty", sQty);
      map.put("sUnitPriceWithoutTax", sUnitPriceWithoutTax);
      map.put("sUnitPriceWithTax", sUnitPriceWithTax);
      map.put("sAmountWithTax", sAmountWithTax);
      map.put("sAmountWithoutTax", sAmountWithoutTax);
      map.put("sTaxType", sTaxType);
      map.put("sTaxRate", sTaxRate);
      map.put("sDiscountRate", sDiscountRate);
      map.put("sPromtFlag", sPromtFlag);
      map.put("sFreeFlag", sFreeFlag);
      map.put("sSuitFlag", sSuitFlag);
      map.put("sSuitInfo", sSuitInfo);
      map.put("sNewOldFlag", sNewOldFlag);
      map.put("sNewOldInfo", sNewOldInfo);
      map.put("sMinOrdQty", sMinOrdQty);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("attribute3", attribute3);
      map.put("attribute4", attribute4);
      map.put("attribute5", attribute5);
      map.put("pUnifyDocFlag", pUnifyDocFlag);
      map.put("pTenantDocFlag", pTenantDocFlag);
      map.put("pBeSplitFlag", pBeSplitFlag);
      map.put("pSplitDocFlag", pSplitDocFlag);
      map.put("pRefBeSplitDocId", pRefBeSplitDocId);
      map.put("pRefBeSplitDocNo", pRefBeSplitDocNo);
      map.put("pRefBeSplitLineId", pRefBeSplitLineId);
      map.put("pSourceFrom", pSourceFrom);
      map.put("sStockKeepingUnit", sStockKeepingUnit);
      map.put("refSettlementHeadId", refSettlementHeadId);
      map.put("refPaymentHeadId", refPaymentHeadId);
      map.put("pBusinessLineId", pBusinessLineId);
      map.put("pDataLineMD5", pDataLineMD5);
      map.put("pDeleteFlag", pDeleteFlag);
      map.put("transState", transState);

       map.put("expenseId.id", expenseIdId);
      return map;
  }

  public static ExpenseSettlementDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ExpenseSettlementDetail entity = new ExpenseSettlementDetail();
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseDocumentNo")) {
      Object obj = map.get("expenseDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deductionType")) {
      Object obj = map.get("deductionType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeductionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseType")) {
      Object obj = map.get("expenseType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseName")) {
      Object obj = map.get("expenseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseAmtWithTax")) {
      Object obj = map.get("expenseAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpenseAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseAmtWithoutTax")) {
      Object obj = map.get("expenseAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpenseAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseDesc")) {
      Object obj = map.get("expenseDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessOccurrenceDate")) {
      Object obj = map.get("businessOccurrenceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBusinessOccurrenceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessOccurrenceDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementDate(null);
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementSubNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManualDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousSettlementNo")) {
      Object obj = map.get("previousSettlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreviousSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseTaxAmt")) {
      Object obj = map.get("expenseTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpenseTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithTax")) {
      Object obj = map.get("salesAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithoutTax")) {
      Object obj = map.get("salesAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoDate(null);
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("protocolNo")) {
      Object obj = map.get("protocolNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProtocolNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumberOD2UD((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysSourceType")) {
      Object obj = map.get("pSysSourceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysSourceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expSumAmtWithTax")) {
      Object obj = map.get("expSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expSumAmtWithoutTax")) {
      Object obj = map.get("expSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expSumTaxAmt")) {
      Object obj = map.get("expSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementSumAmtWithTax")) {
      Object obj = map.get("settlementSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementSumAmtWithoutTax")) {
      Object obj = map.get("settlementSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementSumTaxAmt")) {
      Object obj = map.get("settlementSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paySumAmtWithTax")) {
      Object obj = map.get("paySumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaySumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaySumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaySumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaySumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaySumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paySumAmtWithoutTax")) {
      Object obj = map.get("paySumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaySumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaySumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaySumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaySumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaySumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paySumTaxAmt")) {
      Object obj = map.get("paySumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaySumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaySumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaySumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaySumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaySumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentCode")) {
      Object obj = map.get("sSalesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCategoryCode")) {
      Object obj = map.get("sCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCategoryDesc")) {
      Object obj = map.get("sCategoryDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCategoryDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sWeightUnit")) {
      Object obj = map.get("sWeightUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSWeightUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSTotalWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnitPriceWithoutTax")) {
      Object obj = map.get("sPackageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnitPriceWithTax")) {
      Object obj = map.get("sPackageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageMinOrdQty")) {
      Object obj = map.get("sPackageMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sStockKeepingQty")) {
      Object obj = map.get("sStockKeepingQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSStockKeepingQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSStockKeepingQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSStockKeepingQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSStockKeepingQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSStockKeepingQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sStockKeepingPriceWithoutTax")) {
      Object obj = map.get("sStockKeepingPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSStockKeepingPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSStockKeepingPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSStockKeepingPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSStockKeepingPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSStockKeepingPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sStockKeepingPriceWithTax")) {
      Object obj = map.get("sStockKeepingPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSStockKeepingPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSStockKeepingPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSStockKeepingPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSStockKeepingPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSStockKeepingPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnitRules((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sAmountWithTax")) {
      Object obj = map.get("sAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sAmountWithoutTax")) {
      Object obj = map.get("sAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTaxType")) {
      Object obj = map.get("sTaxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sTaxRate")) {
      Object obj = map.get("sTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPromtFlag")) {
      Object obj = map.get("sPromtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFreeFlag")) {
      Object obj = map.get("sFreeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSFreeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sMinOrdQty")) {
      Object obj = map.get("sMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitLineId")) {
      Object obj = map.get("pRefBeSplitLineId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitLineId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sStockKeepingUnit")) {
      Object obj = map.get("sStockKeepingUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSStockKeepingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSettlementHeadId")) {
      Object obj = map.get("refSettlementHeadId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefSettlementHeadId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPaymentHeadId")) {
      Object obj = map.get("refPaymentHeadId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPaymentHeadId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessLineId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPDataLineMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("transState")) {
      Object obj = map.get("transState");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransState((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("expenseId.id")) {
        Object obj = map.get("expenseId.id");
      if(obj instanceof Long) {
        entity.setExpenseIdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setExpenseIdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseDocumentNo")) {
      Object obj = map.get("expenseDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deductionType")) {
      Object obj = map.get("deductionType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeductionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseType")) {
      Object obj = map.get("expenseType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseName")) {
      Object obj = map.get("expenseName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseAmtWithTax")) {
      Object obj = map.get("expenseAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseAmtWithoutTax")) {
      Object obj = map.get("expenseAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseDesc")) {
      Object obj = map.get("expenseDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessOccurrenceDate")) {
      Object obj = map.get("businessOccurrenceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBusinessOccurrenceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBusinessOccurrenceDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSettlementDate(null);
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementSubNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManualDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("previousSettlementNo")) {
      Object obj = map.get("previousSettlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreviousSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseTaxAmt")) {
      Object obj = map.get("expenseTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesAmtWithTax")) {
      Object obj = map.get("salesAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesAmtWithoutTax")) {
      Object obj = map.get("salesAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPoDate(null);
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("protocolNo")) {
      Object obj = map.get("protocolNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProtocolNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumberOD2UD((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSysSourceType")) {
      Object obj = map.get("pSysSourceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSysSourceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSysNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expSumAmtWithTax")) {
      Object obj = map.get("expSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expSumAmtWithoutTax")) {
      Object obj = map.get("expSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expSumTaxAmt")) {
      Object obj = map.get("expSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlementSumAmtWithTax")) {
      Object obj = map.get("settlementSumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementSumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementSumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementSumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementSumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementSumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlementSumAmtWithoutTax")) {
      Object obj = map.get("settlementSumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementSumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementSumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementSumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementSumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlementSumTaxAmt")) {
      Object obj = map.get("settlementSumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementSumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementSumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementSumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementSumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementSumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paySumAmtWithTax")) {
      Object obj = map.get("paySumAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaySumAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaySumAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaySumAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaySumAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaySumAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paySumAmtWithoutTax")) {
      Object obj = map.get("paySumAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaySumAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaySumAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaySumAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaySumAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaySumAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paySumTaxAmt")) {
      Object obj = map.get("paySumTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaySumTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaySumTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaySumTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaySumTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaySumTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSoldToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSoldToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSShipToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSShipToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDivisionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDivisionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesDepartmentCode")) {
      Object obj = map.get("sSalesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesDepartmentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCategoryCode")) {
      Object obj = map.get("sCategoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCategoryDesc")) {
      Object obj = map.get("sCategoryDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCategoryDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sWeightUnit")) {
      Object obj = map.get("sWeightUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSWeightUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSTotalWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnitPriceWithoutTax")) {
      Object obj = map.get("sPackageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnitPriceWithTax")) {
      Object obj = map.get("sPackageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageMinOrdQty")) {
      Object obj = map.get("sPackageMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sStockKeepingQty")) {
      Object obj = map.get("sStockKeepingQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSStockKeepingQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSStockKeepingQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSStockKeepingQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSStockKeepingQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSStockKeepingQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sStockKeepingPriceWithoutTax")) {
      Object obj = map.get("sStockKeepingPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSStockKeepingPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSStockKeepingPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSStockKeepingPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSStockKeepingPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSStockKeepingPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sStockKeepingPriceWithTax")) {
      Object obj = map.get("sStockKeepingPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSStockKeepingPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSStockKeepingPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSStockKeepingPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSStockKeepingPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSStockKeepingPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnitRules((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sAmountWithTax")) {
      Object obj = map.get("sAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sAmountWithoutTax")) {
      Object obj = map.get("sAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTaxType")) {
      Object obj = map.get("sTaxType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSTaxType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sTaxRate")) {
      Object obj = map.get("sTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPromtFlag")) {
      Object obj = map.get("sPromtFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPromtFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sFreeFlag")) {
      Object obj = map.get("sFreeFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSFreeFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sMinOrdQty")) {
      Object obj = map.get("sMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBeSplitDocId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBeSplitDocNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pRefBeSplitLineId")) {
      Object obj = map.get("pRefBeSplitLineId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBeSplitLineId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSourceFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sStockKeepingUnit")) {
      Object obj = map.get("sStockKeepingUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSStockKeepingUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refSettlementHeadId")) {
      Object obj = map.get("refSettlementHeadId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefSettlementHeadId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPaymentHeadId")) {
      Object obj = map.get("refPaymentHeadId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPaymentHeadId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessLineId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPDataLineMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("transState")) {
      Object obj = map.get("transState");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransState((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("expenseId.id")) {
        Object obj = map.get("expenseId.id");
        if(obj instanceof Long) {
          this.setExpenseIdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpenseIdId(Long.parseLong((String)obj));
        }
      }
  }
}
