package com.xforceplus.ultraman.app.arterydocument.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据状态
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
public enum BillStatus {

    DRAFT("draft", "草稿"),
    CONFIRMED("confirmed", "已提交"),
    DELIVERED("delivered", "已发货");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillStatus fromCode(String code){
        switch(code) {
            case "draft":
                return DRAFT;
            case "confirmed":
                return CONFIRMED;
            case "delivered":
                return DELIVERED;
            default:
                return null;
        }
    }
}
