package com.xforceplus.ultraman.app.arterydocument.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 对账状态
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
public enum MatchStatus {

    WAITING("waiting", "待前序流程处理"),
    TO_BE_RECONCILED("toBeReconciled", "待对账"),
    RECONCILING("reconciling", "对账中"),
    RECONCILED("reconciled", "对账完成"),
    UNRECONCILED("unreconciled", "对账失效"),
    RECONCILE_CONFIRM("reconcileConfirm", "对账确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatus fromCode(String code){
        switch(code) {
            case "waiting":
                return WAITING;
            case "toBeReconciled":
                return TO_BE_RECONCILED;
            case "reconciling":
                return RECONCILING;
            case "reconciled":
                return RECONCILED;
            case "unreconciled":
                return UNRECONCILED;
            case "reconcileConfirm":
                return RECONCILE_CONFIRM;
            default:
                return null;
        }
    }
}
