package com.xforceplus.ultraman.app.arterydocument.metadata.validator;

import com.xforceplus.ultraman.app.arterydocument.metadata.dict.*;
import com.xforceplus.ultraman.app.arterydocument.metadata.validator.annotation.*;

import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.GenericConstraintDef;
import org.hibernate.validator.cfg.defs.*;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * UltramanMetadataValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-02-07
 */
public class EntityMetaValidator implements Validator {

    private Validator validator;

    public EntityMetaValidator() {
        HibernateValidatorConfiguration configuration = Validation
                .byProvider(HibernateValidator.class)
                .configure();

        ConstraintMapping constraintMapping = configuration.createConstraintMapping();

        buildConstraintMapping(constraintMapping);

        this.validator = configuration.addMapping(constraintMapping)
                .buildValidatorFactory()
                .getValidator();
    }

    public <T> Set<ConstraintViolation<T>> validateProperties(T object, String ...propertyNames) {
        return Arrays.asList(propertyNames).stream()
                .map(propertyName -> validator.validateProperty(object, propertyName))
                .flatMap(Collection::stream)
                .collect(Collectors.toSet());
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?>... groups) {
        return validator.validate(object, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?>... groups) {
        return validator.validateProperty(object, propertyName, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?>... groups) {
        return validator.validateValue(beanType, propertyName, value, groups);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return validator.getConstraintsForClass(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return validator.unwrap(type);
    }

    @Override
    public ExecutableValidator forExecutables() {
        return validator.forExecutables();
    }

    private void buildConstraintMapping(ConstraintMapping constraintMapping) {

        // oqsengine_sdk_om_audit_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.OqsengineSdkOmAuditLog.class)
            .field("operatorId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("operatorCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("operatorName")
            .constraint(new LengthDef().min(0).max(200))
            .field("operateType")
            .constraint(new LengthDef().min(0).max(200))
            .field("operateTime")
            .field("appId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("appCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("boId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("boCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("boName")
            .constraint(new LengthDef().min(0).max(200))
            .field("entityId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("requestData")
            .constraint(new LengthDef().min(0).max(5000))
            .field("responseData")
            .constraint(new LengthDef().min(0).max(5000))
            .field("remark")
            .constraint(new LengthDef().min(0).max(500))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // ultraman_sys_bo_user_setting
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.UltramanSysBoUserSetting.class)
            .field("config")
            .constraint(new LengthDef().min(0).max(2000))
            .field("storeKey")
            .constraint(new LengthDef().min(0).max(100))
            .field("extra")
            .constraint(new LengthDef().min(0).max(2000))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // flow_instance_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.FlowInstanceLog.class)
            .field("instanceId")
            .constraint(new LengthDef().min(0).max(36))
            .field("flowCode")
            .constraint(new LengthDef().min(0).max(64))
            .field("errorMsg")
            .constraint(new LengthDef().min(0).max(512))
            .field("exceptionTrace")
            .constraint(new LengthDef().min(0).max(4096))
            .field("errorNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("rollback")
            .field("snapshot")
            .constraint(new LengthDef().min(0).max(4096))
            .field("snapshotFormat")
            .constraint(new LengthDef().min(0).max(128))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SnapshotFormat.class))
            .field("rollbackNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("flowName")
            .constraint(new LengthDef().min(0).max(20))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", FlowStatus.class))
            .field("startSnapshot")
            .constraint(new LengthDef().min(0).max(4096))
            .field("startSnapshotFormat")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", SnapshotFormat.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // flow_replay_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.FlowReplayLog.class)
            .field("flowInstanceId")
            .constraint(new LengthDef().min(0).max(36))
            .field("flowCode")
            .constraint(new LengthDef().min(0).max(64))
            .field("errorMsg")
            .constraint(new LengthDef().min(0).max(512))
            .field("exceptionTrace")
            .constraint(new LengthDef().min(0).max(4096))
            .field("errorNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("rollback")
            .field("rollbackNodeId")
            .constraint(new LengthDef().min(0).max(64))
            .field("status")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", FlowStatus.class))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // goods_receive_note
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.GoodsReceiveNote.class)
            .field("latest")
            .field("srcids")
            .constraint(new LengthDef().min(0).max(1000))
            .field("md5")
            .constraint(new LengthDef().min(0).max(100))
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(100))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(100))
            .field("exceptReceiveDate")
            .field("receiveDate")
            .field("logisticsType")
            .constraint(new LengthDef().min(0).max(100))
            .field("deliverNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("receiveNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("receiptType")
            .constraint(new LengthDef().min(0).max(100))
            .field("createId")
            .constraint(new LengthDef().min(0).max(100))
            .field("createName")
            .constraint(new LengthDef().min(0).max(100))
            .field("createDate")
            .constraint(new LengthDef().min(0).max(100))
            .field("checkerId")
            .constraint(new LengthDef().min(0).max(100))
            .field("checkerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("checkDate")
            .field("sendDate")
            .field("grnCancelDate")
            .field("poType")
            .constraint(new LengthDef().min(0).max(100))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("poItemQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("poTaxAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountTotalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("statementNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("statementStatus")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseReceiveOrgCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseReceiveOrgName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseStoreAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseStoreTel")
            .constraint(new LengthDef().min(0).max(100))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(100))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerAddress")
            .constraint(new LengthDef().min(0).max(100))
            .field("sellerTel")
            .constraint(new LengthDef().min(0).max(100))
            .field("remark")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr1")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr2")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr3")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr4")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr5")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr6")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr7")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr8")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr9")
            .constraint(new LengthDef().min(0).max(100))
            .field("extStr10")
            .constraint(new LengthDef().min(0).max(100))
            .field("vVariableId")
            .constraint(new LengthDef().min(0).max(100))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("receiveStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("priceStatus")
            .constraint(new LengthDef().min(0).max(20))
            .field("docTransformer")
            .constraint(new LengthDef().min(0).max(100))
            .field("businessId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("deliveryDate")
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerRenconStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", MatchStatus.class))
            .field("sellerInvoiceStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceStatus.class))
            ;
        // goods_receive_note_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.GoodsReceiveNoteDetail.class)
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(100))
            .field("lineCreateDate")
            .field("lineUpdateDate")
            .field("itemDesc")
            .constraint(new LengthDef().min(0).max(100))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("firstCategory")
            .constraint(new LengthDef().min(0).max(100))
            .field("secCategory")
            .constraint(new LengthDef().min(0).max(100))
            .field("thirdCategory")
            .constraint(new LengthDef().min(0).max(100))
            .field("barcode")
            .constraint(new LengthDef().min(0).max(100))
            .field("itemSubCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("brand")
            .constraint(new LengthDef().min(0).max(100))
            .field("standards")
            .constraint(new LengthDef().min(0).max(100))
            .field("model")
            .constraint(new LengthDef().min(0).max(100))
            .field("color")
            .constraint(new LengthDef().min(0).max(100))
            .field("size")
            .constraint(new LengthDef().min(0).max(100))
            .field("produceArea")
            .constraint(new LengthDef().min(0).max(100))
            .field("guaranteePeriod")
            .constraint(new LengthDef().min(0).max(100))
            .field("netWeight")
            .constraint(new LengthDef().min(0).max(100))
            .field("totalWeight")
            .constraint(new LengthDef().min(0).max(100))
            .field("volume")
            .constraint(new LengthDef().min(0).max(100))
            .field("volumeUnit")
            .constraint(new LengthDef().min(0).max(100))
            .field("packageSize")
            .constraint(new LengthDef().min(0).max(100))
            .field("packageQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("packageUnit")
            .constraint(new LengthDef().min(0).max(100))
            .field("packageUnitPrice")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("cusItemCode")
            .constraint(new LengthDef().min(0).max(100))
            .field("unitPriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("priceStatus")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unit")
            .constraint(new LengthDef().min(0).max(100))
            .field("receivablePackQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("actualRecPackQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("receivableUnitQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("actualRecUnitQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("receiveMethod")
            .constraint(new LengthDef().min(0).max(100))
            .field("inventory")
            .constraint(new LengthDef().min(0).max(100))
            .field("location")
            .constraint(new LengthDef().min(0).max(100))
            .field("storageGroup")
            .constraint(new LengthDef().min(0).max(100))
            .field("taxType")
            .constraint(new LengthDef().min(0).max(100))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("promtFlag")
            .constraint(new LengthDef().min(0).max(100))
            .field("freeFlag")
            .constraint(new LengthDef().min(0).max(100))
            .field("freeQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("minOrdAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("minOrdQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(100))
            .field("vVariableId")
            .constraint(new LengthDef().min(0).max(100))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithoutTaxDc")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithTaxDc")
            .constraint(new DigitsDef().integer(9).fraction(6))
            ;
        // purchase_order
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.PurchaseOrder.class)
            .field("latest")
            .field("srcids")
            .constraint(new LengthDef().min(0).max(1000))
            .field("md5")
            .constraint(new LengthDef().min(0).max(300))
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCity")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchasePurOrgCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchasePurOrgName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseGroupCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseGroupName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("paperBillAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("elecBillAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("createUser")
            .constraint(new LengthDef().min(0).max(300))
            .field("updateUser")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveContactPerson")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchasePhone")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseFax")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseEmail")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerShipAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerPhone")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerFax")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerEmail")
            .constraint(new LengthDef().min(0).max(300))
            .field("manufacturerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("manufacturerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("bpaNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrdNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purAppNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purAppLineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purContractNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purContractLineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("poType")
            .constraint(new LengthDef().min(0).max(300))
            .field("poDate")
            .field("updateDate")
            .field("approveDate")
            .field("confirmDate")
            .field("validateDays")
            .constraint(new DigitsDef().integer(15).fraction(0))
            .field("deadlineDate")
            .field("poCancelDate")
            .field("totalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("poStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("cancelFlag")
            .constraint(new DigitsDef().integer(15).fraction(0))
            .field("approveType")
            .constraint(new LengthDef().min(0).max(300))
            .field("replenishStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("replenishFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("replenishMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("discountTotalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("promtFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("promtPeriod")
            .constraint(new LengthDef().min(0).max(300))
            .field("promtType")
            .constraint(new LengthDef().min(0).max(300))
            .field("currencyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("currency")
            .constraint(new LengthDef().min(0).max(300))
            .field("exRateDate")
            .field("exRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("exRateType")
            .constraint(new LengthDef().min(0).max(300))
            .field("printFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("printCount")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("logisticsMode")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipType")
            .constraint(new LengthDef().min(0).max(300))
            .field("scheduleDeliveryDate")
            .field("deliveryDate")
            .field("receiveOrgCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveOrgName")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveDate")
            .field("poReceiveQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("receiveAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("settlementOrgCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementOrgName")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementName")
            .constraint(new LengthDef().min(0).max(300))
            .field("payType")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCondtCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCondt")
            .constraint(new LengthDef().min(0).max(300))
            .field("payDiscount")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr1")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr2")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr3")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr4")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr5")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr6")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr7")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr8")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr9")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr10")
            .constraint(new LengthDef().min(0).max(300))
            .field("vvariableid")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("docTransformer")
            .constraint(new LengthDef().min(0).max(300))
            .field("businessId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            ;
        // purchase_order_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.PurchaseOrderDetail.class)
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("poNoticeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("lineCreateDate")
            .field("lineUpdateDate")
            .field("lineCancelDate")
            .field("lineStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("firstCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("secCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("thirdCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("barcode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemSubCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("brand")
            .constraint(new LengthDef().min(0).max(300))
            .field("standards")
            .constraint(new LengthDef().min(0).max(300))
            .field("model")
            .constraint(new LengthDef().min(0).max(300))
            .field("color")
            .constraint(new LengthDef().min(0).max(300))
            .field("size")
            .constraint(new LengthDef().min(0).max(300))
            .field("produceArea")
            .constraint(new LengthDef().min(0).max(300))
            .field("guaranteePeriod")
            .constraint(new LengthDef().min(0).max(300))
            .field("netWeight")
            .constraint(new LengthDef().min(0).max(300))
            .field("totalWeight")
            .constraint(new LengthDef().min(0).max(300))
            .field("volume")
            .constraint(new LengthDef().min(0).max(300))
            .field("volumeUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageSize")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("packageUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageUnitPrice")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("cusItemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("unit")
            .constraint(new LengthDef().min(0).max(300))
            .field("qty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("priceStatus")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("shipmentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("deliveryDate")
            .field("shipMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("receiveTolerance")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("receiveMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("inventory")
            .constraint(new LengthDef().min(0).max(300))
            .field("location")
            .constraint(new LengthDef().min(0).max(300))
            .field("storageGroup")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("promtFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("freeFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("freeQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("minOrdAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("minOrdQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("vvariableid")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("taxStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithoutTaxDc")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithTaxDc")
            .constraint(new DigitsDef().integer(9).fraction(6))
            ;
        // return_to_vendor
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.ReturnToVendor.class)
            .field("latest")
            .field("srcids")
            .constraint(new LengthDef().min(0).max(1000))
            .field("md5")
            .constraint(new LengthDef().min(0).max(300))
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchasePhone")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerPhone")
            .constraint(new LengthDef().min(0).max(300))
            .field("rtvOrderNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("returnNoticeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("rtvDate")
            .field("rtvQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("rtvAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("rtvStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("deliveryDate")
            .field("rtvCancelDate")
            .field("receiveNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("poNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr1")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr2")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr3")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr4")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr5")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr6")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr7")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr8")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr9")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr10")
            .constraint(new LengthDef().min(0).max(300))
            .field("vvariableid")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("docTransformer")
            .constraint(new LengthDef().min(0).max(300))
            .field("businessId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerRenconStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", MatchStatus.class))
            .field("sellerInvoiceStatus")
            .constraint(new LengthDef().min(0).max(20))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceStatus.class))
            ;
        // return_to_vendor_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.ReturnToVendorDetail.class)
            .field("headId")
            .constraint(new LengthDef().min(0).max(300))
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("lineCreateDate")
            .field("lineUpdateDate")
            .field("itemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("barcode")
            .constraint(new LengthDef().min(0).max(300))
            .field("firstCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("secCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("thirdCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemSubCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("brand")
            .constraint(new LengthDef().min(0).max(300))
            .field("standards")
            .constraint(new LengthDef().min(0).max(300))
            .field("model")
            .constraint(new LengthDef().min(0).max(300))
            .field("color")
            .constraint(new LengthDef().min(0).max(300))
            .field("size")
            .constraint(new LengthDef().min(0).max(300))
            .field("produceArea")
            .constraint(new LengthDef().min(0).max(300))
            .field("guaranteePeriod")
            .constraint(new LengthDef().min(0).max(300))
            .field("netWeight")
            .constraint(new LengthDef().min(0).max(300))
            .field("totalWeight")
            .constraint(new LengthDef().min(0).max(300))
            .field("volume")
            .constraint(new LengthDef().min(0).max(300))
            .field("volumeUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("unit")
            .constraint(new LengthDef().min(0).max(300))
            .field("unitPriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("priceStatus")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("cusItemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageSize")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("packageUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageUnitPrice")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("rtvUnitPrice")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("rtvUnitQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("rtvItemAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("rtvReasonType")
            .constraint(new LengthDef().min(0).max(300))
            .field("rtvReason")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("vvariableid")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            ;
        // point_of_sale
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.PointOfSale.class)
            .field("latest")
            .field("srcids")
            .constraint(new LengthDef().min(0).max(1000))
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionBatch")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("statisticalType")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesYear")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesMonth")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesWeek")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("barcode")
            .constraint(new LengthDef().min(0).max(300))
            .field("firstCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("secCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("thirdCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("firstCategoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("secCategoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("thirdCategoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("categoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("categoryName")
            .constraint(new LengthDef().min(0).max(300))
            .field("brand")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemSubCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("standards")
            .constraint(new LengthDef().min(0).max(300))
            .field("unit")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesUnitPrice")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("salesType")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("salesDays")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("purchasePriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("purchasePriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("salesPriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("salesPriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("grossProfit")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("promotionAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("couponDiscount")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr1")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr2")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr3")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr4")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr5")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr6")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr7")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr8")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr9")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr10")
            .constraint(new LengthDef().min(0).max(300))
            .field("vvariableid")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("salesDay")
            .field("docTransformer")
            .constraint(new LengthDef().min(0).max(300))
            ;
        // inventory
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.Inventory.class)
            .field("latest")
            .field("srcids")
            .constraint(new LengthDef().min(0).max(1000))
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionBatch")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionDate")
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterName")
            .constraint(new LengthDef().min(0).max(300))
            .field("categoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("categoryName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("barcode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemSubCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("brand")
            .constraint(new LengthDef().min(0).max(300))
            .field("standards")
            .constraint(new LengthDef().min(0).max(300))
            .field("model")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemStatus")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unit")
            .constraint(new LengthDef().min(0).max(300))
            .field("sectionType")
            .constraint(new LengthDef().min(0).max(300))
            .field("sectionDate")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseQty")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("averagePurchaseAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("salesQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("saleAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("averageSaleQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("stockDate")
            .field("stockQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("stockAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("transitQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("transitAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr1")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr2")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr3")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr4")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr5")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr6")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr7")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr8")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr9")
            .constraint(new LengthDef().min(0).max(300))
            .field("extstr10")
            .constraint(new LengthDef().min(0).max(300))
            .field("vvariableid")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("docTransformer")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // sales_order
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.SalesOrder.class)
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipToCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipToGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipToName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveContactPerson")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchasePhone")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseFax")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseEmail")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrganizationCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrganizationName")
            .constraint(new LengthDef().min(0).max(300))
            .field("createdByCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("createdByName")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesPersonCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesPersonName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerPhone")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerFax")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerEmail")
            .constraint(new LengthDef().min(0).max(300))
            .field("manufacturerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("manufacturerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesDeliveryNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrdNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("associatedPOId")
            .constraint(new LengthDef().min(0).max(300))
            .field("associatedPONo")
            .constraint(new LengthDef().min(0).max(300))
            .field("associatedBillNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseDate")
            .field("purchaseRequestDate")
            .field("salesContractNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesContractLineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesType")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesDate")
            .field("creationDate")
            .field("updateDate")
            .field("approveDate")
            .field("poCancelDate")
            .field("totalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("documentStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("cancelFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("approveType")
            .constraint(new LengthDef().min(0).max(300))
            .field("discountTotalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("promtFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("promtPeriod")
            .constraint(new LengthDef().min(0).max(300))
            .field("promtType")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("logisticsMode")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipType")
            .constraint(new LengthDef().min(0).max(300))
            .field("deliveryFactoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("deliveryFactoryName")
            .constraint(new LengthDef().min(0).max(300))
            .field("deliveryShipperCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("deliveryShipperName")
            .constraint(new LengthDef().min(0).max(300))
            .field("warehouseManagersCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("warehouseManagersName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerShipAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("scheduleDeliveryDate")
            .field("deliveryDate")
            .field("receiveDate")
            .field("currencyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("currency")
            .constraint(new LengthDef().min(0).max(300))
            .field("exRateDate")
            .field("exRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("exRateType")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementOrgCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementOrgName")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementName")
            .constraint(new LengthDef().min(0).max(300))
            .field("payType")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCondtCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCondt")
            .constraint(new LengthDef().min(0).max(300))
            .field("payDiscount")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("businessId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(200))
            .field("latest")
            .field("sellerInvoiceStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceStatus.class))
            .field("sellerRenconStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", MatchStatus.class))
            .field("sellerDocStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", BillStatus.class))
            ;
        // sales_order_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.SalesOrderDetail.class)
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("lineCreateDate")
            .field("lineUpdateDate")
            .field("lineStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("poLineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseItemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseItemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("poNoticeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCategoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCategoryName")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemProductLineCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemProductLineName")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("barcode")
            .constraint(new LengthDef().min(0).max(300))
            .field("universalProductCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemSubCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("brand")
            .constraint(new LengthDef().min(0).max(300))
            .field("standards")
            .constraint(new LengthDef().min(0).max(300))
            .field("model")
            .constraint(new LengthDef().min(0).max(300))
            .field("color")
            .constraint(new LengthDef().min(0).max(300))
            .field("size")
            .constraint(new LengthDef().min(0).max(300))
            .field("produceArea")
            .constraint(new LengthDef().min(0).max(300))
            .field("guaranteePeriod")
            .constraint(new LengthDef().min(0).max(300))
            .field("netWeight")
            .constraint(new LengthDef().min(0).max(300))
            .field("grossWeight")
            .constraint(new LengthDef().min(0).max(300))
            .field("totalWeight")
            .constraint(new LengthDef().min(0).max(300))
            .field("volume")
            .constraint(new LengthDef().min(0).max(300))
            .field("volumeUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageSize")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("packageUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageUnitDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageUnitPrice")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unit")
            .constraint(new LengthDef().min(0).max(300))
            .field("unitDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("qty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("basicUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("basicUnitDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("basicQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("shipmentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("deliveryDate")
            .field("shipMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("inventoryCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("inventoryName")
            .constraint(new LengthDef().min(0).max(300))
            .field("locationCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("locationName")
            .constraint(new LengthDef().min(0).max(300))
            .field("storageGroupCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("storageGroupName")
            .constraint(new LengthDef().min(0).max(300))
            .field("batchNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("manufactureDate")
            .field("expirationDate")
            .field("receiveQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("receiveDate")
            .field("taxType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("discountAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("promtFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("freeFlag")
            .constraint(new LengthDef().min(0).max(300))
            .field("freeQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("minOrdAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("minOrdQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(15))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("qualityGuaranteePeriod")
            .constraint(new LengthDef().min(0).max(20))
            .field("priceStatus")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // expense_bill
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.ExpenseBill.class)
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseDocumentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentType")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCity")
            .constraint(new LengthDef().min(0).max(300))
            .field("businessUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseTaxAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseType")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseName")
            .constraint(new LengthDef().min(0).max(300))
            .field("deductionType")
            .constraint(new LengthDef().min(0).max(300))
            .field("businessOccurrenceDate")
            .field("creationDate")
            .field("contractNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("sellerInvoiceStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceStatus.class))
            .field("sellerRenconStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", MatchStatus.class))
            ;
        // expense_bill_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.ExpenseBillDetail.class)
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseDocumentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentType")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("deductionType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseType")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseName")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("businessOccurrenceDate")
            .field("settlementDate")
            .field("contractNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // settlement_bill
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.SettlementBill.class)
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentType")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseBusinessTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCity")
            .constraint(new LengthDef().min(0).max(300))
            .field("businessUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStorageCenterName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("debitAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("invoicedDeductionAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("payableAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("sujestInvoicedAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("sujestInvoicedAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("sujestInvoicedTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("invoicedAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("settlementDate")
            .field("creationDate")
            .field("approveDate")
            .field("createdBy")
            .constraint(new LengthDef().min(0).max(300))
            .field("approvedBy")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceConfirmBy")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceConfirmTime")
            .field("invoiceCreatedBy")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceCreatedTime")
            .field("logisticsMode")
            .constraint(new LengthDef().min(0).max(300))
            .field("currencyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("currency")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("settlementName")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCondtCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCondtName")
            .constraint(new LengthDef().min(0).max(300))
            .field("schedulePayDate")
            .field("payDate")
            .field("payAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("matchStatus")
            .constraint(new LengthDef().min(0).max(30))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", MatchStatus.class))
            .field("invoiceStatus")
            .constraint(new LengthDef().min(0).max(30))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceStatus.class))
            .field("latest")
            .field("srcids")
            .constraint(new LengthDef().min(0).max(300))
            .field("md5")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerRenconStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", MatchStatus.class))
            .field("sellerInvoiceStatus")
            .constraint(new LengthDef().min(0).max(50))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", InvoiceStatus.class))
            .field("businessId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("priceStatus")
            .constraint(new DigitsDef().integer(20).fraction(0))
            ;
        // receipt_rreturn_settlement_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.ReceiptRreturnSettlementDetail.class)
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("lastSettlementDate")
            .field("settlementDate")
            .field("documentCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentType")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("logisticsMode")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentDate")
            .field("totalAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // expense_settlement_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.ExpenseSettlementDetail.class)
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseDocumentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("regionName")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreGLN")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseStoreName")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentType")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentTypeName")
            .constraint(new LengthDef().min(0).max(300))
            .field("deductionType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseType")
            .constraint(new LengthDef().min(0).max(300))
            .field("expenseName")
            .constraint(new LengthDef().min(0).max(20))
            .field("expenseAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("expenseDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("businessOccurrenceDate")
            .field("settlementDate")
            .field("contractNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // invoice_settlement_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.InvoiceSettlementDetail.class)
            .field("lineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceRequisitionNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceCategory")
            .constraint(new LengthDef().min(0).max(300))
            .field("paperDrewDate")
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amtWithTax")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(100))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // voucher
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.Voucher.class)
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentId")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentType")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentDate")
            .field("creationDate")
            .field("updateDate")
            .field("entryDate")
            .field("netDueDate")
            .field("arrearsAfterNetDueDate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("belongUserCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("belongUserName")
            .constraint(new LengthDef().min(0).max(300))
            .field("refBillingId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refBillingNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refAssignmentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("documentStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrganizationCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrganizationName")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesGroupCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesGroupName")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("totalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("clearingDocument")
            .constraint(new LengthDef().min(0).max(300))
            .field("clearingDate")
            .field("specialGLInd")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerClearingStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerOffsetStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark1")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("latest")
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerGroup")
            .constraint(new LengthDef().min(0).max(300))
            ;
        // payment
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.Payment.class)
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("collectionAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentId")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentType")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentDate")
            .field("settlementSequence")
            .constraint(new LengthDef().min(0).max(300))
            .field("creationDate")
            .field("updateDate")
            .field("refRedIVNoticeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refDocumentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPOId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPONo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPurchaseSettlementId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPurchaseSettlementNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPurchaseSettlementListNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentBank")
            .constraint(new LengthDef().min(0).max(300))
            .field("refund")
            .constraint(new LengthDef().min(0).max(300))
            .field("deadline")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceDate")
            .field("randomPassword")
            .constraint(new LengthDef().min(0).max(300))
            .field("paymentResults")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiverCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiverCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiverCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerSalesGroupCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerSalesGroupName")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("payCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("payAmount")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("payableAmount")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("paidAmont")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remainingPayable")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("sellerOffsetStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("latest")
            .field("srcids")
            .constraint(new LengthDef().min(0).max(1000))
            .field("md5")
            .constraint(new LengthDef().min(0).max(300))
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("vvariableid")
            .constraint(new LengthDef().min(0).max(300))
            .field("docTransformer")
            .constraint(new LengthDef().min(0).max(300))
            ;
        // billing
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.Billing.class)
            .field("belongTenant")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerId")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseRetailerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingId")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingType")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingDate")
            .field("creationDate")
            .field("updateDate")
            .field("refRedIVNoticeNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refDocumentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPOId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPONo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPurchaseSettlementId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPurchaseSettlementNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesContractNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("cancelFlag")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("sellerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCompanyName")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrganizationCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesOrganizationName")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesGroupCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesGroupName")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerType")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerName")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerGroup")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerPhone")
            .constraint(new LengthDef().min(0).max(300))
            .field("customerAddress")
            .constraint(new LengthDef().min(0).max(300))
            .field("payToCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("payToName")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipToCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("shipToName")
            .constraint(new LengthDef().min(0).max(300))
            .field("billToCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("billToName")
            .constraint(new LengthDef().min(0).max(300))
            .field("billToCompanyTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("priceStatus")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("totalAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("invoiceAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("invoiceAmtWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("sellerRenconStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerInvoiceStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("sellerOffsetStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceType")
            .constraint(new LengthDef().min(0).max(300))
            .field("issuingInvoiceType")
            .constraint(new LengthDef().min(0).max(300))
            .field("noInvoiceStatus")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("noInvoiceReason")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaserBankAccount")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaserBankName")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceDate")
            .field("invoiceCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("invoiceNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("currency")
            .constraint(new LengthDef().min(0).max(300))
            .field("exRateDate")
            .field("exRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("exRateType")
            .constraint(new LengthDef().min(0).max(300))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute1")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute2")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute3")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute4")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute5")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute6")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute7")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute8")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute9")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute10")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute11")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute12")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute13")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute14")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute15")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute16")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute17")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute18")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute19")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute20")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            .field("latest")
            .field("versionNo")
            .constraint(new LengthDef().min(0).max(300))
            ;
        // billing_detail
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.BillingDetail.class)
            .field("billingId")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingLineId")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingLineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("postingStatus")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesPersonCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("salesPersonName")
            .constraint(new LengthDef().min(0).max(300))
            .field("refRedNotificationNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refDocumentNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refSOId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refSONo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPOId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refPONo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refSalesDeliveryId")
            .constraint(new LengthDef().min(0).max(300))
            .field("refSalesDeliveryNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("refInternalOrder")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseItemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("purchaseItemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("receiveMethod")
            .constraint(new LengthDef().min(0).max(300))
            .field("invOragnizationCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("invOragnizationName")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemCode")
            .constraint(new LengthDef().min(0).max(300))
            .field("barcode")
            .constraint(new LengthDef().min(0).max(300))
            .field("itemDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("goodsTaxNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageSize")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageQty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("packageUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("packageUnitPrice")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unit")
            .constraint(new LengthDef().min(0).max(300))
            .field("unitDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("qty")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("unitPriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("invoicePriceWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("invoicePriceWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("inPriceDiscountWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("offPriceDiscountWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("invoiceAmtWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithoutTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("amountWithTax")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxAmount")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("priceStatus")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("taxType")
            .constraint(new LengthDef().min(0).max(300))
            .field("taxRate")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("remark")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute1")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute2")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute3")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute4")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute5")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute6")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute7")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute8")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute9")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute10")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute11")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute12")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute13")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute14")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute15")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute16")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute17")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute18")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute19")
            .constraint(new LengthDef().min(0).max(300))
            .field("attribute20")
            .constraint(new LengthDef().min(0).max(300))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
        // billing_detail_discount
        constraintMapping
            .type(com.xforceplus.ultraman.app.arterydocument.metadata.entity.BillingDetailDiscount.class)
            .field("billingId")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingLineId")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingLineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("billingDiscountLineNo")
            .constraint(new LengthDef().min(0).max(300))
            .field("discountType")
            .constraint(new LengthDef().min(0).max(300))
            .field("discountTypeDesc")
            .constraint(new LengthDef().min(0).max(300))
            .field("discountUnit")
            .constraint(new LengthDef().min(0).max(300))
            .field("discountAmt")
            .constraint(new DigitsDef().integer(9).fraction(6))
            .field("id")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("tenantCode")
            .constraint(new LengthDef().min(0).max(200))
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("updateUserId")
            .constraint(new DigitsDef().integer(20).fraction(0))
            .field("createUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("updateUserName")
            .constraint(new LengthDef().min(0).max(200))
            .field("deleteFlag")
            .constraint(new LengthDef().min(0).max(2))
            ;
    }
}
