package com.xforceplus.ultraman.app.arterydocument.metadata.validator;

import com.xforceplus.ultraman.app.arterydocument.metadata.validator.annotation.CheckUltramanEmail;


import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-02-07
 */
public class UltramanEmailConstraintValidator implements ConstraintValidator<CheckUltramanEmail, String> {

    private final String MSG_FORMAT = "value suffix must one of %s";

    private final String TYPE_NO_LIMIT = "1";

    private final String TYPE_LIMIT = "2";

    String type;

    String emailSuffixes;

    @Override
    public void initialize(CheckUltramanEmail constraintAnnotation) {
        type = constraintAnnotation.type();
        emailSuffixes = constraintAnnotation.emailSuffixes();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }
        if(!TYPE_LIMIT.equals(type)) {
            return true;
        }
        if(null == emailSuffixes || emailSuffixes.length() == 0) {
            return true;
        }

        boolean isValid = Arrays.asList(emailSuffixes.split(","))
                .stream().filter(suffix -> value.endsWith(suffix)).count() > 0;

        if(!isValid) {
            unValidMsg(context, emailSuffixes);
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
