package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * goods_receive_note_detail
 * </p>
 *
 * @author ultraman
 * @since 2023-02-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsReceiveNoteDetail implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 行编号
   */
  private String lineNo;
  /**
   * 采购订单编号
   */
  private String poNo;
  /**
   * 行创建日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lineCreateDate;
  /**
   * 行更新日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lineUpdateDate;
  /**
   * 商品名称
   */
  private String itemDesc;
  /**
   * 商品编码
   */
  private String itemCode;
  /**
   * 商品大类
   */
  private String firstCategory;
  /**
   * 商品中类
   */
  private String secCategory;
  /**
   * 商品小类
   */
  private String thirdCategory;
  /**
   * 商品条码
   */
  private String barcode;
  /**
   * 商品子编码
   */
  private String itemSubCode;
  /**
   * 品牌
   */
  private String brand;
  /**
   * 规格
   */
  private String standards;
  /**
   * 型号
   */
  private String model;
  /**
   * 颜色
   */
  private String color;
  /**
   * 尺寸
   */
  private String size;
  /**
   * 产地
   */
  private String produceArea;
  /**
   * 保质期
   */
  private String guaranteePeriod;
  /**
   * 净重量
   */
  private String netWeight;
  /**
   * 总重量
   */
  private String totalWeight;
  /**
   * 体积
   */
  private String volume;
  /**
   * 体积单位
   */
  private String volumeUnit;
  /**
   * 批量包装规格
   */
  private String packageSize;
  /**
   * 批量包装数量
   */
  private BigDecimal packageQty;
  /**
   * 批量包装单位
   */
  private String packageUnit;
  /**
   * 批量包装单价
   */
  private BigDecimal packageUnitPrice;
  /**
   * 供应商商品编码
   */
  private String cusItemCode;
  /**
   * 进单价（不含税）
   */
  private BigDecimal unitPriceWithoutTax;
  /**
   * 进单价（含税）
   */
  private BigDecimal unitPriceWithTax;
  /**
   * 价格方式
   */
  private BigDecimal priceStatus;
  /**
   * 基本单位
   */
  private String unit;
  /**
   * 应收件数
   */
  private BigDecimal receivablePackQty;
  /**
   * 实收件数
   */
  private BigDecimal actualRecPackQty;
  /**
   * 应收数量
   */
  private BigDecimal receivableUnitQty;
  /**
   * 实收数量
   */
  private BigDecimal actualRecUnitQty;
  /**
   * 接收方式
   */
  private String receiveMethod;
  /**
   * 库房
   */
  private String inventory;
  /**
   * 库位
   */
  private String location;
  /**
   * 存放组
   */
  private String storageGroup;
  /**
   * 税收分类
   */
  private String taxType;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 折扣率
   */
  private BigDecimal discountRate;
  /**
   * 折扣金额
   */
  private BigDecimal discountAmt;
  /**
   * 是否促销
   */
  private String promtFlag;
  /**
   * 是否赠品
   */
  private String freeFlag;
  /**
   * 赠品数量
   */
  private BigDecimal freeQty;
  /**
   * 最低起订含税金额
   */
  private BigDecimal minOrdAmt;
  /**
   * 最低起订量
   */
  private BigDecimal minOrdQty;
  /**
   * 备注
   */
  private String remark;
  /**
   * 模版变量Id
   */
  private String vVariableId;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 进价总额（不含税）
   */
  private BigDecimal amountWithoutTax;
  /**
   * 进价总额（含税）
   */
  private BigDecimal amountWithTax;
  /**
   * 本币进价总额（不含税）
   */
  private BigDecimal amountWithoutTaxDc;
  /**
   * 本币进价总额（含税）
   */
  private BigDecimal amountWithTaxDc;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;

  /**
   * 对一关联关系 关联对象 goodsReceiveNote
   */
  private Long headIdId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("poNo", poNo);
      map.put("lineCreateDate", BocpGenUtils.toTimestamp(lineCreateDate));
      map.put("lineUpdateDate", BocpGenUtils.toTimestamp(lineUpdateDate));
      map.put("itemDesc", itemDesc);
      map.put("itemCode", itemCode);
      map.put("firstCategory", firstCategory);
      map.put("secCategory", secCategory);
      map.put("thirdCategory", thirdCategory);
      map.put("barcode", barcode);
      map.put("itemSubCode", itemSubCode);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("model", model);
      map.put("color", color);
      map.put("size", size);
      map.put("produceArea", produceArea);
      map.put("guaranteePeriod", guaranteePeriod);
      map.put("netWeight", netWeight);
      map.put("totalWeight", totalWeight);
      map.put("volume", volume);
      map.put("volumeUnit", volumeUnit);
      map.put("packageSize", packageSize);
      map.put("packageQty", packageQty);
      map.put("packageUnit", packageUnit);
      map.put("packageUnitPrice", packageUnitPrice);
      map.put("cusItemCode", cusItemCode);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("priceStatus", priceStatus);
      map.put("unit", unit);
      map.put("receivablePackQty", receivablePackQty);
      map.put("actualRecPackQty", actualRecPackQty);
      map.put("receivableUnitQty", receivableUnitQty);
      map.put("actualRecUnitQty", actualRecUnitQty);
      map.put("receiveMethod", receiveMethod);
      map.put("inventory", inventory);
      map.put("location", location);
      map.put("storageGroup", storageGroup);
      map.put("taxType", taxType);
      map.put("taxRate", taxRate);
      map.put("discountRate", discountRate);
      map.put("discountAmt", discountAmt);
      map.put("promtFlag", promtFlag);
      map.put("freeFlag", freeFlag);
      map.put("freeQty", freeQty);
      map.put("minOrdAmt", minOrdAmt);
      map.put("minOrdQty", minOrdQty);
      map.put("remark", remark);
      map.put("vVariableId", vVariableId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTaxDc", amountWithoutTaxDc);
      map.put("amountWithTaxDc", amountWithTaxDc);
      map.put("goodsTaxNo", goodsTaxNo);

      map.put("headId.id", headIdId);
      return map;
  }

  public static GoodsReceiveNoteDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsReceiveNoteDetail entity = new GoodsReceiveNoteDetail();

    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineCreateDate")) {
      Object obj = map.get("lineCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLineCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLineCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLineCreateDate(null);
      }
    }
    if(map.containsKey("lineUpdateDate")) {
      Object obj = map.get("lineUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLineUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLineUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLineUpdateDate(null);
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secCategory")) {
      Object obj = map.get("secCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSecCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("color")) {
      Object obj = map.get("color");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("size")) {
      Object obj = map.get("size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("produceArea")) {
      Object obj = map.get("produceArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProduceArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guaranteePeriod")) {
      Object obj = map.get("guaranteePeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGuaranteePeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalWeight")) {
      Object obj = map.get("totalWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolumeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCusItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPriceStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPriceStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPriceStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivablePackQty")) {
      Object obj = map.get("receivablePackQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivablePackQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivablePackQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivablePackQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivablePackQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivablePackQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actualRecPackQty")) {
      Object obj = map.get("actualRecPackQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualRecPackQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualRecPackQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualRecPackQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualRecPackQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualRecPackQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivableUnitQty")) {
      Object obj = map.get("receivableUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actualRecUnitQty")) {
      Object obj = map.get("actualRecUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualRecUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualRecUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualRecUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualRecUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualRecUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receiveMethod")) {
      Object obj = map.get("receiveMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inventory")) {
      Object obj = map.get("inventory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("location")) {
      Object obj = map.get("location");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageGroup")) {
      Object obj = map.get("storageGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStorageGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeFlag")) {
      Object obj = map.get("freeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeQty")) {
      Object obj = map.get("freeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdAmt")) {
      Object obj = map.get("minOrdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMinOrdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMinOrdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMinOrdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMinOrdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMinOrdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdQty")) {
      Object obj = map.get("minOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vVariableId")) {
      Object obj = map.get("vVariableId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVVariableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTaxDc")) {
      Object obj = map.get("amountWithoutTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxDc")) {
      Object obj = map.get("amountWithTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("headId.id")) {
       Object obj = map.get("headId.id");
       if(obj instanceof Long) {
         entity.setHeadIdId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setHeadIdId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineCreateDate")) {
      Object obj = map.get("lineCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLineCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLineCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLineCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLineCreateDate(null);
      }
    }
    if(map.containsKey("lineUpdateDate")) {
      Object obj = map.get("lineUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLineUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLineUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLineUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLineUpdateDate(null);
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secCategory")) {
      Object obj = map.get("secCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSecCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setThirdCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("color")) {
      Object obj = map.get("color");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("size")) {
      Object obj = map.get("size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("produceArea")) {
      Object obj = map.get("produceArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProduceArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guaranteePeriod")) {
      Object obj = map.get("guaranteePeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGuaranteePeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNetWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalWeight")) {
      Object obj = map.get("totalWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVolumeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCusItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPriceStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPriceStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPriceStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPriceStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPriceStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivablePackQty")) {
      Object obj = map.get("receivablePackQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivablePackQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivablePackQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivablePackQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivablePackQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivablePackQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actualRecPackQty")) {
      Object obj = map.get("actualRecPackQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setActualRecPackQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setActualRecPackQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setActualRecPackQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setActualRecPackQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setActualRecPackQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivableUnitQty")) {
      Object obj = map.get("receivableUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivableUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivableUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivableUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivableUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actualRecUnitQty")) {
      Object obj = map.get("actualRecUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setActualRecUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setActualRecUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setActualRecUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setActualRecUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setActualRecUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receiveMethod")) {
      Object obj = map.get("receiveMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inventory")) {
      Object obj = map.get("inventory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("location")) {
      Object obj = map.get("location");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageGroup")) {
      Object obj = map.get("storageGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStorageGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeFlag")) {
      Object obj = map.get("freeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFreeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeQty")) {
      Object obj = map.get("freeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdAmt")) {
      Object obj = map.get("minOrdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMinOrdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMinOrdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMinOrdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMinOrdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMinOrdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdQty")) {
      Object obj = map.get("minOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vVariableId")) {
      Object obj = map.get("vVariableId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVVariableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTaxDc")) {
      Object obj = map.get("amountWithoutTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxDc")) {
      Object obj = map.get("amountWithTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("headId.id")) {
    Object obj = map.get("headId.id");
    if(obj instanceof Long) {
        this.setHeadIdId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setHeadIdId(Long.parseLong((String)obj));
    }
  }
  }
}
