package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * voucher
 * </p>
 *
 * @author ultraman
 * @since 2023-02-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Voucher implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 所属租户
   */
  private String belongTenant;
  /**
   * 零售商编码
   */
  private String purchaseRetailerId;
  /**
   * 零售商描述
   */
  private String purchaseRetailerName;
  /**
   * 凭证编号
   */
  private String documentNo;
  /**
   * 凭证类型
   */
  private String documentType;
  /**
   * 凭证日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;
  /**
   * 创建日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;
  /**
   * 更新日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateDate;
  /**
   * 输入日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime entryDate;
  /**
   * 到期日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime netDueDate;
  /**
   * 逾期天数
   */
  private BigDecimal arrearsAfterNetDueDate;
  /**
   * 所属用户编码
   */
  private String belongUserCode;
  /**
   * 所属用户
   */
  private String belongUserName;
  /**
   * 关联billing单ID
   */
  private String refBillingId;
  /**
   * 关联billing单号
   */
  private String refBillingNo;
  /**
   * 关联参考编号
   */
  private String refAssignmentNo;
  /**
   * 单据状态
   */
  private String documentStatus;
  /**
   * 销方类型
   */
  private String sellerType;
  /**
   * 销方统一社会信用代码
   */
  private String sellerCompanyTaxNo;
  /**
   * 销方公司编码
   */
  private String sellerCompanyCode;
  /**
   * 销方公司名称
   */
  private String sellerCompanyName;
  /**
   * 销方编码
   */
  private String sellerCode;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销售组织编码
   */
  private String salesOrganizationCode;
  /**
   * 销售组织名称
   */
  private String salesOrganizationName;
  /**
   * 销售组编码
   */
  private String salesGroupCode;
  /**
   * 销售组名称
   */
  private String salesGroupName;
  /**
   * 客户类型
   */
  private String customerType;
  /**
   * 客户编码
   */
  private String customerCode;
  /**
   * 客户名称
   */
  private String customerName;
  /**
   * 总金额（含税）
   */
  private BigDecimal totalAmt;
  /**
   * 总金额（不含税）
   */
  private BigDecimal totalAmtWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmt;
  /**
   * 清账凭证
   */
  private String clearingDocument;
  /**
   * 清账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime clearingDate;
  /**
   * 特殊总账标识
   */
  private String specialGLInd;
  /**
   * 销方清账状态
   */
  private String sellerClearingStatus;
  /**
   * 销方冲账状态
   */
  private String sellerOffsetStatus;
  /**
   * 备注
   */
  private String remark;
  /**
   * 备注1
   */
  private String remark1;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 是否是最新版本
   */
  private Boolean latest;
  /**
   * 版本号
   */
  private String versionNo;
  /**
   * 客户组
   */
  private String customerGroup;
  /**
   * 过账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;
  /**
   * 关联参考
   */
  private String reference;
  /**
   * 业务Id
   */
  private String pBusinessId;
  /**
   * 销方清账状态
   */
  private String pSellerClearingStatus;
  /**
   * 销方冲账状态
   */
  private String pSellerOffsetStatus;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("documentNo", documentNo);
      map.put("documentType", documentType);
      map.put("documentDate", BocpGenUtils.toTimestamp(documentDate));
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("updateDate", BocpGenUtils.toTimestamp(updateDate));
      map.put("entryDate", BocpGenUtils.toTimestamp(entryDate));
      map.put("netDueDate", BocpGenUtils.toTimestamp(netDueDate));
      map.put("arrearsAfterNetDueDate", arrearsAfterNetDueDate);
      map.put("belongUserCode", belongUserCode);
      map.put("belongUserName", belongUserName);
      map.put("refBillingId", refBillingId);
      map.put("refBillingNo", refBillingNo);
      map.put("refAssignmentNo", refAssignmentNo);
      map.put("documentStatus", documentStatus);
      map.put("sellerType", sellerType);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("salesOrganizationCode", salesOrganizationCode);
      map.put("salesOrganizationName", salesOrganizationName);
      map.put("salesGroupCode", salesGroupCode);
      map.put("salesGroupName", salesGroupName);
      map.put("customerType", customerType);
      map.put("customerCode", customerCode);
      map.put("customerName", customerName);
      map.put("totalAmt", totalAmt);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("taxAmt", taxAmt);
      map.put("clearingDocument", clearingDocument);
      map.put("clearingDate", BocpGenUtils.toTimestamp(clearingDate));
      map.put("specialGLInd", specialGLInd);
      map.put("sellerClearingStatus", sellerClearingStatus);
      map.put("sellerOffsetStatus", sellerOffsetStatus);
      map.put("remark", remark);
      map.put("remark1", remark1);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("latest", latest);
      map.put("versionNo", versionNo);
      map.put("customerGroup", customerGroup);
      map.put("postingDate", BocpGenUtils.toTimestamp(postingDate));
      map.put("reference", reference);
      map.put("pBusinessId", pBusinessId);
      map.put("pSellerClearingStatus", pSellerClearingStatus);
      map.put("pSellerOffsetStatus", pSellerOffsetStatus);

      return map;
  }

  public static Voucher fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Voucher entity = new Voucher();

    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateDate(null);
      }
    }
    if(map.containsKey("entryDate")) {
      Object obj = map.get("entryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEntryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEntryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEntryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEntryDate(null);
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNetDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setNetDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNetDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setNetDueDate(null);
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setArrearsAfterNetDueDate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setArrearsAfterNetDueDate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setArrearsAfterNetDueDate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setArrearsAfterNetDueDate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setArrearsAfterNetDueDate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("belongUserCode")) {
      Object obj = map.get("belongUserCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongUserName")) {
      Object obj = map.get("belongUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refBillingId")) {
      Object obj = map.get("refBillingId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefBillingId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refBillingNo")) {
      Object obj = map.get("refBillingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refAssignmentNo")) {
      Object obj = map.get("refAssignmentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefAssignmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupCode")) {
      Object obj = map.get("salesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupName")) {
      Object obj = map.get("salesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDate")) {
      Object obj = map.get("clearingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setClearingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setClearingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setClearingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setClearingDate(null);
      }
    }
    if(map.containsKey("specialGLInd")) {
      Object obj = map.get("specialGLInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialGLInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerClearingStatus")) {
      Object obj = map.get("sellerClearingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerClearingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerOffsetStatus")) {
      Object obj = map.get("sellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerOffsetStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark1")) {
      Object obj = map.get("remark1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerGroup")) {
      Object obj = map.get("customerGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerClearingStatus")) {
      Object obj = map.get("pSellerClearingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerClearingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerOffsetStatus")) {
      Object obj = map.get("pSellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerOffsetStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDocumentDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateDate(null);
      }
    }
    if(map.containsKey("entryDate")) {
      Object obj = map.get("entryDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEntryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEntryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEntryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEntryDate(null);
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setNetDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setNetDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNetDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setNetDueDate(null);
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setArrearsAfterNetDueDate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setArrearsAfterNetDueDate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setArrearsAfterNetDueDate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setArrearsAfterNetDueDate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setArrearsAfterNetDueDate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("belongUserCode")) {
      Object obj = map.get("belongUserCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongUserName")) {
      Object obj = map.get("belongUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refBillingId")) {
      Object obj = map.get("refBillingId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefBillingId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refBillingNo")) {
      Object obj = map.get("refBillingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refAssignmentNo")) {
      Object obj = map.get("refAssignmentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefAssignmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupCode")) {
      Object obj = map.get("salesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupName")) {
      Object obj = map.get("salesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDate")) {
      Object obj = map.get("clearingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setClearingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setClearingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setClearingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setClearingDate(null);
      }
    }
    if(map.containsKey("specialGLInd")) {
      Object obj = map.get("specialGLInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialGLInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerClearingStatus")) {
      Object obj = map.get("sellerClearingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerClearingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerOffsetStatus")) {
      Object obj = map.get("sellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerOffsetStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark1")) {
      Object obj = map.get("remark1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerGroup")) {
      Object obj = map.get("customerGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPostingDate(null);
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerClearingStatus")) {
      Object obj = map.get("pSellerClearingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSellerClearingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerOffsetStatus")) {
      Object obj = map.get("pSellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSellerOffsetStatus((String)obj);
        }
      } else{
      }
    }
  }
}
