package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * point_of_sale
 * </p>
 *
 * @author ultraman
 * @since 2023-03-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PointOfSale implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 是否是最新版本
   */
  private Boolean latest;
  /**
   * 原始单据Id数组
   */
  private String srcids;
  /**
   * 所属租户
   */
  private String belongTenant;
  /**
   * 采集批次
   */
  private String collectionBatch;
  /**
   * 商超账号
   */
  private String collectionAccount;
  /**
   * 统计类型
   */
  private String statisticalType;
  /**
   * 销售年份
   */
  private String salesYear;
  /**
   * 销售月份
   */
  private String salesMonth;
  /**
   * 销售周
   */
  private String salesWeek;
  /**
   * 购方门店编码
   */
  private String purchaseStoreCode;
  /**
   * 购方门店名称
   */
  private String purchaseStoreName;
  /**
   * 购方公司名称
   */
  private String purchaseCompanyName;
  /**
   * 购方公司编码
   */
  private String purchaseCompanyCode;
  /**
   * 零售商编码
   */
  private String purchaseRetailerId;
  /**
   * 零售商描述
   */
  private String purchaseRetailerName;
  /**
   * 购方统一社会信用代码
   */
  private String purchaseCompanyTaxNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方统一社会信用代码
   */
  private String sellerCompanyTaxNo;
  /**
   * 购方门店GLN
   */
  private String purchaseStoreGLN;
  /**
   * 区域编码
   */
  private String regionCode;
  /**
   * 区域名称
   */
  private String regionName;
  /**
   * 业态编码
   */
  private String purchaseBusinessTypeNo;
  /**
   * 业态名称
   */
  private String purchaseBusinessTypeName;
  /**
   * 销方编码
   */
  private String sellerCode;
  /**
   * 商品编码
   */
  private String itemCode;
  /**
   * 商品条码
   */
  private String barcode;
  /**
   * 商品大类
   */
  private String firstCategory;
  /**
   * 商品中类
   */
  private String secCategory;
  /**
   * 商品小类
   */
  private String thirdCategory;
  /**
   * 商品大类编码
   */
  private String firstCategoryCode;
  /**
   * 商品中类编码
   */
  private String secCategoryCode;
  /**
   * 商品小类编码
   */
  private String thirdCategoryCode;
  /**
   * 品类编码
   */
  private String categoryCode;
  /**
   * 品类名称
   */
  private String categoryName;
  /**
   * 品牌
   */
  private String brand;
  /**
   * 商品子编码
   */
  private String itemSubCode;
  /**
   * 商品名称
   */
  private String itemDesc;
  /**
   * 规格
   */
  private String standards;
  /**
   * 基本单位
   */
  private String unit;
  /**
   * 商品销售单价
   */
  private BigDecimal salesUnitPrice;
  /**
   * 销售方式
   */
  private String salesType;
  /**
   * 销售数量
   */
  private BigDecimal salesQty;
  /**
   * 销售天数
   */
  private BigDecimal salesDays;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 进价含税金额
   */
  private BigDecimal purchasePriceWithTax;
  /**
   * 进价不含税金额
   */
  private BigDecimal purchasePriceWithoutTax;
  /**
   * 销售含税金额
   */
  private BigDecimal salesPriceWithTax;
  /**
   * 销售未含税金额
   */
  private BigDecimal salesPriceWithoutTax;
  /**
   * 商品毛利金额
   */
  private BigDecimal grossProfit;
  /**
   * 促销金额
   */
  private BigDecimal promotionAmt;
  /**
   * 优惠券折扣金额
   */
  private BigDecimal couponDiscount;
  /**
   * 备注
   */
  private String remark;
  /**
   * 扩展字段_字符串_1
   */
  private String extstr1;
  /**
   * 扩展字段_字符串_2
   */
  private String extstr2;
  /**
   * 扩展字段_字符串_3
   */
  private String extstr3;
  /**
   * 扩展字段_字符串_4
   */
  private String extstr4;
  /**
   * 扩展字段_字符串_5
   */
  private String extstr5;
  /**
   * 扩展字段_字符串_6
   */
  private String extstr6;
  /**
   * 扩展字段_字符串_7
   */
  private String extstr7;
  /**
   * 扩展字段_字符串_8
   */
  private String extstr8;
  /**
   * 扩展字段_字符串_9
   */
  private String extstr9;
  /**
   * 扩展字段_字符串_10
   */
  private String extstr10;
  /**
   * 模版变量Id
   */
  private String vvariableid;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 销售日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime salesDay;
  /**
   * 转换方式
   */
  private String docTransformer;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("belongTenant", belongTenant);
      map.put("collectionBatch", collectionBatch);
      map.put("collectionAccount", collectionAccount);
      map.put("statisticalType", statisticalType);
      map.put("salesYear", salesYear);
      map.put("salesMonth", salesMonth);
      map.put("salesWeek", salesWeek);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("sellerCode", sellerCode);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("firstCategory", firstCategory);
      map.put("secCategory", secCategory);
      map.put("thirdCategory", thirdCategory);
      map.put("firstCategoryCode", firstCategoryCode);
      map.put("secCategoryCode", secCategoryCode);
      map.put("thirdCategoryCode", thirdCategoryCode);
      map.put("categoryCode", categoryCode);
      map.put("categoryName", categoryName);
      map.put("brand", brand);
      map.put("itemSubCode", itemSubCode);
      map.put("itemDesc", itemDesc);
      map.put("standards", standards);
      map.put("unit", unit);
      map.put("salesUnitPrice", salesUnitPrice);
      map.put("salesType", salesType);
      map.put("salesQty", salesQty);
      map.put("salesDays", salesDays);
      map.put("taxRate", taxRate);
      map.put("purchasePriceWithTax", purchasePriceWithTax);
      map.put("purchasePriceWithoutTax", purchasePriceWithoutTax);
      map.put("salesPriceWithTax", salesPriceWithTax);
      map.put("salesPriceWithoutTax", salesPriceWithoutTax);
      map.put("grossProfit", grossProfit);
      map.put("promotionAmt", promotionAmt);
      map.put("couponDiscount", couponDiscount);
      map.put("remark", remark);
      map.put("extstr1", extstr1);
      map.put("extstr2", extstr2);
      map.put("extstr3", extstr3);
      map.put("extstr4", extstr4);
      map.put("extstr5", extstr5);
      map.put("extstr6", extstr6);
      map.put("extstr7", extstr7);
      map.put("extstr8", extstr8);
      map.put("extstr9", extstr9);
      map.put("extstr10", extstr10);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesDay", BocpGenUtils.toTimestamp(salesDay));
      map.put("docTransformer", docTransformer);

      return map;
  }

  public static PointOfSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PointOfSale entity = new PointOfSale();

    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticalType")) {
      Object obj = map.get("statisticalType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatisticalType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesYear")) {
      Object obj = map.get("salesYear");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesMonth")) {
      Object obj = map.get("salesMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesWeek")) {
      Object obj = map.get("salesWeek");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesWeek((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secCategory")) {
      Object obj = map.get("secCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSecCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategoryCode")) {
      Object obj = map.get("firstCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secCategoryCode")) {
      Object obj = map.get("secCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSecCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategoryCode")) {
      Object obj = map.get("thirdCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesUnitPrice")) {
      Object obj = map.get("salesUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesDays")) {
      Object obj = map.get("salesDays");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesDays((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesDays(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesDays(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesDays(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesDays(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchasePriceWithTax")) {
      Object obj = map.get("purchasePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchasePriceWithoutTax")) {
      Object obj = map.get("purchasePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesPriceWithTax")) {
      Object obj = map.get("salesPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesPriceWithoutTax")) {
      Object obj = map.get("salesPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("grossProfit")) {
      Object obj = map.get("grossProfit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotionAmt")) {
      Object obj = map.get("promotionAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("couponDiscount")) {
      Object obj = map.get("couponDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCouponDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCouponDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCouponDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCouponDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCouponDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDay")) {
      Object obj = map.get("salesDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSalesDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSalesDay(null);
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticalType")) {
      Object obj = map.get("statisticalType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatisticalType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesYear")) {
      Object obj = map.get("salesYear");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesMonth")) {
      Object obj = map.get("salesMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesWeek")) {
      Object obj = map.get("salesWeek");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesWeek((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secCategory")) {
      Object obj = map.get("secCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSecCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setThirdCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategoryCode")) {
      Object obj = map.get("firstCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secCategoryCode")) {
      Object obj = map.get("secCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSecCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategoryCode")) {
      Object obj = map.get("thirdCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setThirdCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesUnitPrice")) {
      Object obj = map.get("salesUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesDays")) {
      Object obj = map.get("salesDays");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesDays((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesDays(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesDays(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesDays(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesDays(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchasePriceWithTax")) {
      Object obj = map.get("purchasePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchasePriceWithoutTax")) {
      Object obj = map.get("purchasePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesPriceWithTax")) {
      Object obj = map.get("salesPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesPriceWithoutTax")) {
      Object obj = map.get("salesPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("grossProfit")) {
      Object obj = map.get("grossProfit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotionAmt")) {
      Object obj = map.get("promotionAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPromotionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPromotionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPromotionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPromotionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPromotionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("couponDiscount")) {
      Object obj = map.get("couponDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCouponDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCouponDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCouponDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCouponDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCouponDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDay")) {
      Object obj = map.get("salesDay");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSalesDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSalesDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSalesDay(null);
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocTransformer((String)obj);
        }
      } else{
      }
    }
  }
}
