package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * billing
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Billing implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 所属租户
   */
  private String belongTenant;
  /**
   * 零售商编码
   */
  private String purchaseRetailerId;
  /**
   * 零售商描述
   */
  private String purchaseRetailerName;
  /**
   * billing单编号
   */
  private String billingNo;
  /**
   * 单据类型
   */
  private String billingType;
  /**
   * 单据日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billingDate;
  /**
   * 创建日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;
  /**
   * 更新日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateDate;
  /**
   * 关联红字通知单号
   */
  private String refRedIVNoticeNo;
  /**
   * 关联凭证编号
   */
  private String refDocumentNo;
  /**
   * 关联采购订单ID
   */
  private String refPOId;
  /**
   * 关联采购订单编号
   */
  private String refPONo;
  /**
   * 关联购方结算单ID
   */
  private String refPurchaseSettlementId;
  /**
   * 关联购方结算单号
   */
  private String refPurchaseSettlementNo;
  /**
   * 单据状态
   */
  private String billingStatus;
  /**
   * 取消标识
   */
  private BigDecimal cancelFlag;
  /**
   * 销方类型
   */
  private String sellerType;
  /**
   * 销方统一社会信用代码
   */
  private String sellerCompanyTaxNo;
  /**
   * 销方公司编码
   */
  private String sellerCompanyCode;
  /**
   * 销方公司名称
   */
  private String sellerCompanyName;
  /**
   * 销方编码
   */
  private String sellerCode;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销售组织编码
   */
  private String salesOrganizationCode;
  /**
   * 销售组织名称
   */
  private String salesOrganizationName;
  /**
   * 销售组编码
   */
  private String salesGroupCode;
  /**
   * 销售组名称
   */
  private String salesGroupName;
  /**
   * 客户类型
   */
  private String customerType;
  /**
   * 客户编码
   */
  private String customerCode;
  /**
   * 客户名称
   */
  private String customerName;
  /**
   * 客户组
   */
  private String customerGroup;
  /**
   * 客户联系电话
   */
  private String customerPhone;
  /**
   * 客户地址
   */
  private String customerAddress;
  /**
   * 付款方编码
   */
  private String payToCode;
  /**
   * 付款方名称
   */
  private String payToName;
  /**
   * 送达方编码
   */
  private String shipToCode;
  /**
   * 送达方名称
   */
  private String shipToName;
  /**
   * 收票方公司编码
   */
  private String billToCode;
  /**
   * 收票方公司名称
   */
  private String billToName;
  /**
   * 收票方统一社会信用代码
   */
  private String billToCompanyTaxNo;
  /**
   * 价格方式
   */
  private BigDecimal priceStatus;
  /**
   * 总金额（含税）
   */
  private BigDecimal totalAmt;
  /**
   * 总金额（不含税）
   */
  private BigDecimal totalAmtWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmt;
  /**
   * 开票金额（含税）
   */
  private BigDecimal invoiceAmtWithTax;
  /**
   * 开票金额（不含税）
   */
  private BigDecimal invoiceAmtWithoutTax;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 开票类型
   */
  private String issuingInvoiceType;
  /**
   * 不开票原因
   */
  private String noInvoiceReason;
  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;
  /**
   * 购方银行名称
   */
  private String purchaserBankName;
  /**
   * 发票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 币种
   */
  private String currency;
  /**
   * 汇率日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exRateDate;
  /**
   * 汇率
   */
  private BigDecimal exRate;
  /**
   * 汇率类型
   */
  private String exRateType;
  /**
   * 备注
   */
  private String remark;
  /**
   * 自定义字段1
   */
  private String attribute1;
  /**
   * 自定义字段2
   */
  private String attribute2;
  /**
   * 自定义字段3
   */
  private String attribute3;
  /**
   * 自定义字段4
   */
  private String attribute4;
  /**
   * 自定义字段5
   */
  private String attribute5;
  /**
   * 自定义字段6
   */
  private String attribute6;
  /**
   * 自定义字段7
   */
  private String attribute7;
  /**
   * 自定义字段8
   */
  private String attribute8;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 是否是最新版本
   */
  private Boolean latest;
  /**
   * 版本号
   */
  private String versionNo;
  /**
   * 业务Id
   */
  private String pBusinessId;
  /**
   * 销方对账状态
   */
  private String pSellerRenconStatus;
  /**
   * 销方开票状态
   */
  private String pSellerInvoiceStatus;
  /**
   * 特殊收票方编码
   */
  private String specialBillToCode;
  /**
   * 不开票标识
   */
  private String noInvoiceStatus;
  /**
   * 国税发票来源
   */
  private String taxInvoiceSource;
  /**
   * 不开票原因描述
   */
  private String noInvoiceReasonDesc;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("billingNo", billingNo);
      map.put("billingType", billingType);
      map.put("billingDate", BocpGenUtils.toTimestamp(billingDate));
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("updateDate", BocpGenUtils.toTimestamp(updateDate));
      map.put("refRedIVNoticeNo", refRedIVNoticeNo);
      map.put("refDocumentNo", refDocumentNo);
      map.put("refPOId", refPOId);
      map.put("refPONo", refPONo);
      map.put("refPurchaseSettlementId", refPurchaseSettlementId);
      map.put("refPurchaseSettlementNo", refPurchaseSettlementNo);
      map.put("billingStatus", billingStatus);
      map.put("cancelFlag", cancelFlag);
      map.put("sellerType", sellerType);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("salesOrganizationCode", salesOrganizationCode);
      map.put("salesOrganizationName", salesOrganizationName);
      map.put("salesGroupCode", salesGroupCode);
      map.put("salesGroupName", salesGroupName);
      map.put("customerType", customerType);
      map.put("customerCode", customerCode);
      map.put("customerName", customerName);
      map.put("customerGroup", customerGroup);
      map.put("customerPhone", customerPhone);
      map.put("customerAddress", customerAddress);
      map.put("payToCode", payToCode);
      map.put("payToName", payToName);
      map.put("shipToCode", shipToCode);
      map.put("shipToName", shipToName);
      map.put("billToCode", billToCode);
      map.put("billToName", billToName);
      map.put("billToCompanyTaxNo", billToCompanyTaxNo);
      map.put("priceStatus", priceStatus);
      map.put("totalAmt", totalAmt);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("taxAmt", taxAmt);
      map.put("invoiceAmtWithTax", invoiceAmtWithTax);
      map.put("invoiceAmtWithoutTax", invoiceAmtWithoutTax);
      map.put("invoiceType", invoiceType);
      map.put("issuingInvoiceType", issuingInvoiceType);
      map.put("noInvoiceReason", noInvoiceReason);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("purchaserBankName", purchaserBankName);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("currency", currency);
      map.put("exRateDate", BocpGenUtils.toTimestamp(exRateDate));
      map.put("exRate", exRate);
      map.put("exRateType", exRateType);
      map.put("remark", remark);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("attribute3", attribute3);
      map.put("attribute4", attribute4);
      map.put("attribute5", attribute5);
      map.put("attribute6", attribute6);
      map.put("attribute7", attribute7);
      map.put("attribute8", attribute8);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("latest", latest);
      map.put("versionNo", versionNo);
      map.put("pBusinessId", pBusinessId);
      map.put("pSellerRenconStatus", pSellerRenconStatus);
      map.put("pSellerInvoiceStatus", pSellerInvoiceStatus);
      map.put("specialBillToCode", specialBillToCode);
      map.put("noInvoiceStatus", noInvoiceStatus);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("noInvoiceReasonDesc", noInvoiceReasonDesc);

      return map;
  }

  public static Billing fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Billing entity = new Billing();

    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDate")) {
      Object obj = map.get("billingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillingDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateDate(null);
      }
    }
    if(map.containsKey("refRedIVNoticeNo")) {
      Object obj = map.get("refRedIVNoticeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefRedIVNoticeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementId")) {
      Object obj = map.get("refPurchaseSettlementId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPurchaseSettlementId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementNo")) {
      Object obj = map.get("refPurchaseSettlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPurchaseSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingStatus")) {
      Object obj = map.get("billingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCancelFlag((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCancelFlag(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCancelFlag(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCancelFlag(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCancelFlag(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupCode")) {
      Object obj = map.get("salesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupName")) {
      Object obj = map.get("salesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerGroup")) {
      Object obj = map.get("customerGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerPhone")) {
      Object obj = map.get("customerPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerAddress")) {
      Object obj = map.get("customerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payToCode")) {
      Object obj = map.get("payToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payToName")) {
      Object obj = map.get("payToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToCode")) {
      Object obj = map.get("billToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToName")) {
      Object obj = map.get("billToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToCompanyTaxNo")) {
      Object obj = map.get("billToCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPriceStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPriceStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPriceStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuingInvoiceType")) {
      Object obj = map.get("issuingInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuingInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceReason")) {
      Object obj = map.get("noInvoiceReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoInvoiceReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerRenconStatus")) {
      Object obj = map.get("pSellerRenconStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerRenconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialBillToCode")) {
      Object obj = map.get("specialBillToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialBillToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceStatus")) {
      Object obj = map.get("noInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceReasonDesc")) {
      Object obj = map.get("noInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoInvoiceReasonDesc((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDate")) {
      Object obj = map.get("billingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBillingDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateDate(null);
      }
    }
    if(map.containsKey("refRedIVNoticeNo")) {
      Object obj = map.get("refRedIVNoticeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefRedIVNoticeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefPOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementId")) {
      Object obj = map.get("refPurchaseSettlementId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefPurchaseSettlementId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementNo")) {
      Object obj = map.get("refPurchaseSettlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefPurchaseSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingStatus")) {
      Object obj = map.get("billingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCancelFlag((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCancelFlag(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCancelFlag(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCancelFlag(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCancelFlag(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupCode")) {
      Object obj = map.get("salesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupName")) {
      Object obj = map.get("salesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerGroup")) {
      Object obj = map.get("customerGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerPhone")) {
      Object obj = map.get("customerPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerAddress")) {
      Object obj = map.get("customerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payToCode")) {
      Object obj = map.get("payToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payToName")) {
      Object obj = map.get("payToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToCode")) {
      Object obj = map.get("billToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToName")) {
      Object obj = map.get("billToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToCompanyTaxNo")) {
      Object obj = map.get("billToCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillToCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPriceStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPriceStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPriceStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPriceStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPriceStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuingInvoiceType")) {
      Object obj = map.get("issuingInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIssuingInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceReason")) {
      Object obj = map.get("noInvoiceReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNoInvoiceReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setInvoiceDate(null);
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerRenconStatus")) {
      Object obj = map.get("pSellerRenconStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSellerRenconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSellerInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialBillToCode")) {
      Object obj = map.get("specialBillToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialBillToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceStatus")) {
      Object obj = map.get("noInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNoInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceReasonDesc")) {
      Object obj = map.get("noInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNoInvoiceReasonDesc((String)obj);
        }
      } else{
      }
    }
  }
}
