package com.xforceplus.ultraman.app.arterydocument.metadata.validator;

import com.xforceplus.ultraman.app.arterydocument.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.arterydocument.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PSourceFrom.class)) {
            isValid = null != PSourceFrom.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerClearingStatus.class)) {
            isValid = null != SellerClearingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerClearingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerOffsetStatus.class)) {
            isValid = null != SellerOffsetStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerOffsetStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
