package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销方开票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum InvoiceStatus {

    WAITING("waiting", "待前序流程处理"),
    TO_BE_INVOICED("toBeInvoiced", "待开票"),
    INVOICING("invoicing", "开票中"),
    INVOICED("invoiced", "开票完成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code) {
        return Stream.of(InvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
