package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * doc_transfer_state
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
public enum DocTransferState {

    _0("0", "未转换"),
    _1("1", "转换失败"),
    _2("2", "转换成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocTransferState(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocTransferState fromCode(String code) {
        return Stream.of(DocTransferState.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
