package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * exception_ignore_reason
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
public enum ExceptionIgnoreReason {

    _1("1", "业务标签执行忽略"),
    _2("2", "手工忽略"),
    _3("3", "错误转换超最大次忽略");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExceptionIgnoreReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionIgnoreReason fromCode(String code) {
        return Stream.of(ExceptionIgnoreReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
