package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_invoice_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
public enum RedInvoiceFlag {

    _0("0", "非红票"),
    _1("1", "红票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedInvoiceFlag fromCode(String code) {
        return Stream.of(RedInvoiceFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
