package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * billing_detail
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillingDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * billing单编号
   */
  private String billingNo;
  /**
   * billing单行编号
   */
  private String billingLineNo;
  /**
   * 过账状态
   */
  private String postingStatus;
  /**
   * 销售员编码
   */
  private String salesPersonCode;
  /**
   * 销售员
   */
  private String salesPersonName;
  /**
   * 关联红字通知单号
   */
  private String refRedNotificationNo;
  /**
   * 关联凭证编号
   */
  private String refDocumentNo;
  /**
   * 关联销售订单ID
   */
  private String refSOId;
  /**
   * 关联销售订单号
   */
  private String refSONo;
  /**
   * 关联采购订单ID
   */
  private String refPOId;
  /**
   * 关联采购订单编号
   */
  private String refPONo;
  /**
   * 关联销售出库单ID
   */
  private String refSalesDeliveryId;
  /**
   * 关联销售出库单号
   */
  private String refSalesDeliveryNo;
  /**
   * 关联内部订单号
   */
  private String refInternalOrder;
  /**
   * 采购订单商品编号
   */
  private String purchaseItemCode;
  /**
   * 采购订单商品名称
   */
  private String purchaseItemDesc;
  /**
   * 接收方式
   */
  private String receiveMethod;
  /**
   * 发货库存组织编码
   */
  private String invOragnizationCode;
  /**
   * 发货库存组织名称
   */
  private String invOragnizationName;
  /**
   * 商品编码
   */
  private String itemCode;
  /**
   * 商品条码
   */
  private String barcode;
  /**
   * 商品名称
   */
  private String itemDesc;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;
  /**
   * 批量包装规格
   */
  private String packageSize;
  /**
   * 批量包装数量
   */
  private BigDecimal packageQty;
  /**
   * 批量包装单位
   */
  private String packageUnit;
  /**
   * 批量包装单价
   */
  private BigDecimal packageUnitPrice;
  /**
   * 单据单位
   */
  private String unit;
  /**
   * 单据单位描述
   */
  private String unitDesc;
  /**
   * 单据数量
   */
  private BigDecimal qty;
  /**
   * 单价（不含税）
   */
  private BigDecimal unitPriceWithoutTax;
  /**
   * 单价（含税）
   */
  private BigDecimal unitPriceWithTax;
  /**
   * 开票单价（不含税）
   */
  private BigDecimal invoicePriceWithoutTax;
  /**
   * 开票单价（含税）
   */
  private BigDecimal invoicePriceWithTax;
  /**
   * 价内折扣金额（含税）
   */
  private BigDecimal inPriceDiscountWithTax;
  /**
   * 价外折扣金额（含税）
   */
  private BigDecimal offPriceDiscountWithTax;
  /**
   * 开票金额（含税）
   */
  private BigDecimal invoiceAmtWithTax;
  /**
   * 总额（不含税）
   */
  private BigDecimal amountWithoutTax;
  /**
   * 总额（含税）
   */
  private BigDecimal amountWithTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 税收分类
   */
  private String taxType;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 备注
   */
  private String remark;
  /**
   * 自定义字段1
   */
  private String attribute1;
  /**
   * 自定义字段2
   */
  private String attribute2;
  /**
   * 自定义字段3
   */
  private String attribute3;
  /**
   * 自定义字段4
   */
  private String attribute4;
  /**
   * 自定义字段5
   */
  private String attribute5;
  /**
   * 自定义字段6
   */
  private String attribute6;
  /**
   * 自定义字段7
   */
  private String attribute7;
  /**
   * 自定义字段8
   */
  private String attribute8;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 销售合同号
   */
  private String salesContractNo;
  /**
   * 开票金额（不含税）
   */
  private BigDecimal invoiceAmtWithoutTax;
  /**
   * 价内折扣金额（不含税）
   */
  private BigDecimal inPriceDiscountWithoutTax;
  /**
   * 价外折扣金额（不含税）
   */
  private BigDecimal offPriceDiscountWithoutTax;
  /**
   * 品牌
   */
  private String brand;
  /**
   * 规格
   */
  private String standards;
  /**
   * 特殊商品类型
   */
  private String specialItemType;
  /**
   * 开票税额
   */
  private BigDecimal invoiceTaxAmount;
  /**
   * 金额1(含税)
   */
  private BigDecimal amount1WithTax;
  /**
   * 金额1(不含税)
   */
  private BigDecimal amount1WithoutTax;
  /**
   * 金额2(含税)
   */
  private BigDecimal amount2WithTax;
  /**
   * 金额2(不含税)
   */
  private BigDecimal amount2WithoutTax;
  /**
   * 金额3(含税)
   */
  private BigDecimal amount3WithTax;
  /**
   * 金额3(不含税)
   */
  private BigDecimal amount3WithoutTax;
  /**
   * 金额4(含税)
   */
  private BigDecimal amount4WithTax;
  /**
   * 金额4(不含税)
   */
  private BigDecimal amount4WithoutTax;
  /**
   * 金额5(含税)
   */
  private BigDecimal amount5WithTax;
  /**
   * 金额5(不含税)
   */
  private BigDecimal amount5WithoutTax;
  /**
   * 批量包装单位描述
   */
  private String packageUnitDesc;
  /**
   * 批量包装单价(不含税)
   */
  private BigDecimal packageUnitPriceWithoutTax;
  /**
   * 最小单位
   */
  private String stockKeepingUnit;
  /**
   * 最小单位描述
   */
  private String stockKeepingUnitDesc;
  /**
   * 最小单位数量
   */
  private BigDecimal skuQty;
  /**
   * 最小单位单价(含税)
   */
  private BigDecimal skuPriceWithTax;
  /**
   * 最小单位单价(不含税)
   */
  private BigDecimal skuPriceWithoutTax;

  /**
   * 对一关联关系 关联对象 billing
   */
  private Long headIdId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("billingNo", billingNo);
      map.put("billingLineNo", billingLineNo);
      map.put("postingStatus", postingStatus);
      map.put("salesPersonCode", salesPersonCode);
      map.put("salesPersonName", salesPersonName);
      map.put("refRedNotificationNo", refRedNotificationNo);
      map.put("refDocumentNo", refDocumentNo);
      map.put("refSOId", refSOId);
      map.put("refSONo", refSONo);
      map.put("refPOId", refPOId);
      map.put("refPONo", refPONo);
      map.put("refSalesDeliveryId", refSalesDeliveryId);
      map.put("refSalesDeliveryNo", refSalesDeliveryNo);
      map.put("refInternalOrder", refInternalOrder);
      map.put("purchaseItemCode", purchaseItemCode);
      map.put("purchaseItemDesc", purchaseItemDesc);
      map.put("receiveMethod", receiveMethod);
      map.put("invOragnizationCode", invOragnizationCode);
      map.put("invOragnizationName", invOragnizationName);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemDesc", itemDesc);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("packageSize", packageSize);
      map.put("packageQty", packageQty);
      map.put("packageUnit", packageUnit);
      map.put("packageUnitPrice", packageUnitPrice);
      map.put("unit", unit);
      map.put("unitDesc", unitDesc);
      map.put("qty", qty);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("invoicePriceWithoutTax", invoicePriceWithoutTax);
      map.put("invoicePriceWithTax", invoicePriceWithTax);
      map.put("inPriceDiscountWithTax", inPriceDiscountWithTax);
      map.put("offPriceDiscountWithTax", offPriceDiscountWithTax);
      map.put("invoiceAmtWithTax", invoiceAmtWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("taxAmount", taxAmount);
      map.put("taxType", taxType);
      map.put("taxRate", taxRate);
      map.put("remark", remark);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("attribute3", attribute3);
      map.put("attribute4", attribute4);
      map.put("attribute5", attribute5);
      map.put("attribute6", attribute6);
      map.put("attribute7", attribute7);
      map.put("attribute8", attribute8);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesContractNo", salesContractNo);
      map.put("invoiceAmtWithoutTax", invoiceAmtWithoutTax);
      map.put("inPriceDiscountWithoutTax", inPriceDiscountWithoutTax);
      map.put("offPriceDiscountWithoutTax", offPriceDiscountWithoutTax);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("specialItemType", specialItemType);
      map.put("invoiceTaxAmount", invoiceTaxAmount);
      map.put("amount1WithTax", amount1WithTax);
      map.put("amount1WithoutTax", amount1WithoutTax);
      map.put("amount2WithTax", amount2WithTax);
      map.put("amount2WithoutTax", amount2WithoutTax);
      map.put("amount3WithTax", amount3WithTax);
      map.put("amount3WithoutTax", amount3WithoutTax);
      map.put("amount4WithTax", amount4WithTax);
      map.put("amount4WithoutTax", amount4WithoutTax);
      map.put("amount5WithTax", amount5WithTax);
      map.put("amount5WithoutTax", amount5WithoutTax);
      map.put("packageUnitDesc", packageUnitDesc);
      map.put("packageUnitPriceWithoutTax", packageUnitPriceWithoutTax);
      map.put("stockKeepingUnit", stockKeepingUnit);
      map.put("stockKeepingUnitDesc", stockKeepingUnitDesc);
      map.put("skuQty", skuQty);
      map.put("skuPriceWithTax", skuPriceWithTax);
      map.put("skuPriceWithoutTax", skuPriceWithoutTax);

      map.put("headId.id", headIdId);
      return map;
  }

  public static BillingDetail fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillingDetail entity = new BillingDetail();

    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingLineNo")) {
      Object obj = map.get("billingLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingStatus")) {
      Object obj = map.get("postingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonCode")) {
      Object obj = map.get("salesPersonCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesPersonCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonName")) {
      Object obj = map.get("salesPersonName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesPersonName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refRedNotificationNo")) {
      Object obj = map.get("refRedNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSOId")) {
      Object obj = map.get("refSOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefSOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSONo")) {
      Object obj = map.get("refSONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefSONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSalesDeliveryId")) {
      Object obj = map.get("refSalesDeliveryId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefSalesDeliveryId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSalesDeliveryNo")) {
      Object obj = map.get("refSalesDeliveryNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefSalesDeliveryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refInternalOrder")) {
      Object obj = map.get("refInternalOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefInternalOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseItemCode")) {
      Object obj = map.get("purchaseItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseItemDesc")) {
      Object obj = map.get("purchaseItemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveMethod")) {
      Object obj = map.get("receiveMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invOragnizationCode")) {
      Object obj = map.get("invOragnizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvOragnizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invOragnizationName")) {
      Object obj = map.get("invOragnizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvOragnizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitDesc")) {
      Object obj = map.get("unitDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnitDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePriceWithoutTax")) {
      Object obj = map.get("invoicePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePriceWithTax")) {
      Object obj = map.get("invoicePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inPriceDiscountWithTax")) {
      Object obj = map.get("inPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("offPriceDiscountWithTax")) {
      Object obj = map.get("offPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOffPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOffPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOffPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOffPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOffPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesContractNo")) {
      Object obj = map.get("salesContractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inPriceDiscountWithoutTax")) {
      Object obj = map.get("inPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("offPriceDiscountWithoutTax")) {
      Object obj = map.get("offPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOffPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOffPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOffPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialItemType")) {
      Object obj = map.get("specialItemType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialItemType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTaxAmount")) {
      Object obj = map.get("invoiceTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount1WithTax")) {
      Object obj = map.get("amount1WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount1WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount1WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount1WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount1WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount1WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount1WithoutTax")) {
      Object obj = map.get("amount1WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount1WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount1WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount1WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount1WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount1WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount2WithTax")) {
      Object obj = map.get("amount2WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount2WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount2WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount2WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount2WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount2WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount2WithoutTax")) {
      Object obj = map.get("amount2WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount2WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount2WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount2WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount2WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount2WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount3WithTax")) {
      Object obj = map.get("amount3WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount3WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount3WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount3WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount3WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount3WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount3WithoutTax")) {
      Object obj = map.get("amount3WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount3WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount3WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount3WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount3WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount3WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount4WithTax")) {
      Object obj = map.get("amount4WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount4WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount4WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount4WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount4WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount4WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount4WithoutTax")) {
      Object obj = map.get("amount4WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount4WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount4WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount4WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount4WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount4WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount5WithTax")) {
      Object obj = map.get("amount5WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount5WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount5WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount5WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount5WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount5WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount5WithoutTax")) {
      Object obj = map.get("amount5WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount5WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount5WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount5WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount5WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount5WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitDesc")) {
      Object obj = map.get("packageUnitDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageUnitDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithoutTax")) {
      Object obj = map.get("packageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockKeepingUnit")) {
      Object obj = map.get("stockKeepingUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockKeepingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stockKeepingUnitDesc")) {
      Object obj = map.get("stockKeepingUnitDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockKeepingUnitDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("skuQty")) {
      Object obj = map.get("skuQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSkuQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSkuQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSkuQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("skuPriceWithTax")) {
      Object obj = map.get("skuPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSkuPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSkuPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSkuPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("skuPriceWithoutTax")) {
      Object obj = map.get("skuPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSkuPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSkuPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSkuPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    if(map.containsKey("headId.id")) {
       Object obj = map.get("headId.id");
       if(obj instanceof Long) {
         entity.setHeadIdId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setHeadIdId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingLineNo")) {
      Object obj = map.get("billingLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingStatus")) {
      Object obj = map.get("postingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPostingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonCode")) {
      Object obj = map.get("salesPersonCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesPersonCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesPersonName")) {
      Object obj = map.get("salesPersonName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesPersonName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refRedNotificationNo")) {
      Object obj = map.get("refRedNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSOId")) {
      Object obj = map.get("refSOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefSOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSONo")) {
      Object obj = map.get("refSONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefSONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefPOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSalesDeliveryId")) {
      Object obj = map.get("refSalesDeliveryId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefSalesDeliveryId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refSalesDeliveryNo")) {
      Object obj = map.get("refSalesDeliveryNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefSalesDeliveryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refInternalOrder")) {
      Object obj = map.get("refInternalOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefInternalOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseItemCode")) {
      Object obj = map.get("purchaseItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseItemDesc")) {
      Object obj = map.get("purchaseItemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveMethod")) {
      Object obj = map.get("receiveMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invOragnizationCode")) {
      Object obj = map.get("invOragnizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvOragnizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invOragnizationName")) {
      Object obj = map.get("invOragnizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvOragnizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitDesc")) {
      Object obj = map.get("unitDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnitDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePriceWithoutTax")) {
      Object obj = map.get("invoicePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoicePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoicePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoicePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoicePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoicePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePriceWithTax")) {
      Object obj = map.get("invoicePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoicePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoicePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoicePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoicePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoicePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inPriceDiscountWithTax")) {
      Object obj = map.get("inPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("offPriceDiscountWithTax")) {
      Object obj = map.get("offPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOffPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOffPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOffPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOffPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOffPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesContractNo")) {
      Object obj = map.get("salesContractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inPriceDiscountWithoutTax")) {
      Object obj = map.get("inPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("offPriceDiscountWithoutTax")) {
      Object obj = map.get("offPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOffPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOffPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOffPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialItemType")) {
      Object obj = map.get("specialItemType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialItemType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTaxAmount")) {
      Object obj = map.get("invoiceTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount1WithTax")) {
      Object obj = map.get("amount1WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount1WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount1WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount1WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount1WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount1WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount1WithoutTax")) {
      Object obj = map.get("amount1WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount1WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount1WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount1WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount1WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount1WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount2WithTax")) {
      Object obj = map.get("amount2WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount2WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount2WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount2WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount2WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount2WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount2WithoutTax")) {
      Object obj = map.get("amount2WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount2WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount2WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount2WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount2WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount2WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount3WithTax")) {
      Object obj = map.get("amount3WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount3WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount3WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount3WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount3WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount3WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount3WithoutTax")) {
      Object obj = map.get("amount3WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount3WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount3WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount3WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount3WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount3WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount4WithTax")) {
      Object obj = map.get("amount4WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount4WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount4WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount4WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount4WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount4WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount4WithoutTax")) {
      Object obj = map.get("amount4WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount4WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount4WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount4WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount4WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount4WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount5WithTax")) {
      Object obj = map.get("amount5WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount5WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount5WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount5WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount5WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount5WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount5WithoutTax")) {
      Object obj = map.get("amount5WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount5WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount5WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount5WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount5WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount5WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitDesc")) {
      Object obj = map.get("packageUnitDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageUnitDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithoutTax")) {
      Object obj = map.get("packageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockKeepingUnit")) {
      Object obj = map.get("stockKeepingUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStockKeepingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stockKeepingUnitDesc")) {
      Object obj = map.get("stockKeepingUnitDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStockKeepingUnitDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("skuQty")) {
      Object obj = map.get("skuQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSkuQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSkuQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSkuQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSkuQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSkuQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("skuPriceWithTax")) {
      Object obj = map.get("skuPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSkuPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSkuPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSkuPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSkuPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSkuPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("skuPriceWithoutTax")) {
      Object obj = map.get("skuPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSkuPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSkuPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSkuPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSkuPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSkuPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
  if(map.containsKey("headId.id")) {
    Object obj = map.get("headId.id");
    if(obj instanceof Long) {
        this.setHeadIdId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setHeadIdId(Long.parseLong((String)obj));
    }
  }
  }
}
