package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * receipt_rreturn_settlement_detail
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceiptRreturnSettlementDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 序号
   */
  private String lineNo;
  /**
   * 区域编码
   */
  private String regionCode;
  /**
   * 区域名称
   */
  private String regionName;
  /**
   * 上次结算日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastSettlementDate;
  /**
   * 本次结算日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementDate;
  /**
   * 单据类别
   */
  private String documentCategory;
  /**
   * 单据类型编码
   */
  private String documentType;
  /**
   * 单据类型名称
   */
  private String documentTypeName;
  /**
   * 单据编号
   */
  private String documentNo;
  /**
   * 门店编码
   */
  private String purchaseStoreCode;
  /**
   * 门店GLN
   */
  private String purchaseStoreGLN;
  /**
   * 门店名称
   */
  private String purchaseStoreName;
  /**
   * 物流模式
   */
  private String logisticsMode;
  /**
   * 单据发生日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;
  /**
   * 不含税金额
   */
  private BigDecimal totalAmtWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmt;
  /**
   * 含税金额
   */
  private BigDecimal totalAmtWithTax;
  /**
   * 备注
   */
  private String remark;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 关联采购订单编号
   */
  private String refPONo;
  /**
   * 结算单子单号
   */
  private String settlementSubNo;
  /**
   * 手工单号
   */
  private String manualDocumentNo;
  /**
   * 单据总数量
   */
  private BigDecimal totalQty;
  /**
   * 扣除金额（含税）
   */
  private BigDecimal deductAmt;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 送货单号
   */
  private String deliveryDocNo;
  /**
   * 采购日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poDate;
  /**
   * 扣除金额（不含税）
   */
  private BigDecimal deductAmtWithoutTax;
  /**
   * 销售金额（含税）
   */
  private BigDecimal salesAmtWithTax;
  /**
   * 销售金额（不含税）
   */
  private BigDecimal salesAmtWithoutTax;
  /**
   * 折扣率
   */
  private BigDecimal disRate;
  /**
   * 应结日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementDueDate;
  /**
   * 结算金额(含税)
   */
  private BigDecimal settlementAmtWithTax;
  /**
   * 结算金额（不含税）
   */
  private BigDecimal settlementAmtWithoutTax;
  /**
   * 销方销售组编码
   */
  private String sSalesGroupCode;
  /**
   * 销方销售组名称
   */
  private String sSalesGroupName;
  /**
   * 售达方编码
   */
  private String sSoldToCode;
  /**
   * 售达方名称
   */
  private String sSoldToName;
  /**
   * 送达方编码
   */
  private String sShipToCode;
  /**
   * 送达方名称
   */
  private String sShipToName;
  /**
   * 客户组编码
   */
  private String sCustomerGroupCode;
  /**
   * 客户组名称
   */
  private String sCustomerGroupName;
  /**
   * 客户类型
   */
  private String sCustomerType;
  /**
   * 客户编码
   */
  private String sCustomerCode;
  /**
   * 客户名称
   */
  private String sCustomerName;
  /**
   * 固定折扣率
   */
  private BigDecimal sFixedDiscountRate;
  /**
   * 业务单元编码
   */
  private String sBuCode;
  /**
   * 业务单元名称
   */
  private String sBuName;
  /**
   * 销售公司编码
   */
  private String sCompanyCode;
  /**
   * 销售公司名称
   */
  private String sCompanyName;
  /**
   * 销售公司税号
   */
  private String sCompanyTaxNo;
  /**
   * 销售组织编码
   */
  private String sSalesOrganizationCode;
  /**
   * 销售组织名称
   */
  private String sSalesOrganizationName;
  /**
   * 产品组编码
   */
  private String sDivisionCode;
  /**
   * 产品组名称
   */
  private String sDivisionName;
  /**
   * 分销渠道编码
   */
  private String sDistributionChannelCode;
  /**
   * 分销渠道名称
   */
  private String sDistributionChannelName;
  /**
   * 销售部门编码
   */
  private String sSalesDepartmentCode;
  /**
   * 销售部门名称
   */
  private String sSalesDepartmentName;
  /**
   * 工厂编码
   */
  private String sPlantCode;
  /**
   * 工厂名称
   */
  private String sPlantName;
  /**
   * 统一单据标记
   */
  private Boolean pUnifyDocFlag;
  /**
   * 租户单据标记
   */
  private Boolean pTenantDocFlag;
  /**
   * 被拆分标记
   */
  private Boolean pBeSplitFlag;
  /**
   * 拆分单标记
   */
  private Boolean pSplitDocFlag;
  /**
   * 关联被拆分单据ID
   */
  private String pRefBeSplitDocId;
  /**
   * 关联被拆分单据编号
   */
  private String pRefBeSplitDocNo;
  /**
   * 修订采购订单编号
   */
  private String sRevisedPONo;
  /**
   * 系统单据编号
   */
  private String pSysNo;

  /**
   * 对一关联关系 关联对象 settlementBill
   */
  private Long grIdId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("lastSettlementDate", BocpGenUtils.toTimestamp(lastSettlementDate));
      map.put("settlementDate", BocpGenUtils.toTimestamp(settlementDate));
      map.put("documentCategory", documentCategory);
      map.put("documentType", documentType);
      map.put("documentTypeName", documentTypeName);
      map.put("documentNo", documentNo);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("logisticsMode", logisticsMode);
      map.put("documentDate", BocpGenUtils.toTimestamp(documentDate));
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("taxAmt", taxAmt);
      map.put("totalAmtWithTax", totalAmtWithTax);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("refPONo", refPONo);
      map.put("settlementSubNo", settlementSubNo);
      map.put("manualDocumentNo", manualDocumentNo);
      map.put("totalQty", totalQty);
      map.put("deductAmt", deductAmt);
      map.put("taxRate", taxRate);
      map.put("deliveryDocNo", deliveryDocNo);
      map.put("poDate", BocpGenUtils.toTimestamp(poDate));
      map.put("deductAmtWithoutTax", deductAmtWithoutTax);
      map.put("salesAmtWithTax", salesAmtWithTax);
      map.put("salesAmtWithoutTax", salesAmtWithoutTax);
      map.put("disRate", disRate);
      map.put("settlementDueDate", BocpGenUtils.toTimestamp(settlementDueDate));
      map.put("settlementAmtWithTax", settlementAmtWithTax);
      map.put("settlementAmtWithoutTax", settlementAmtWithoutTax);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("sSoldToCode", sSoldToCode);
      map.put("sSoldToName", sSoldToName);
      map.put("sShipToCode", sShipToCode);
      map.put("sShipToName", sShipToName);
      map.put("sCustomerGroupCode", sCustomerGroupCode);
      map.put("sCustomerGroupName", sCustomerGroupName);
      map.put("sCustomerType", sCustomerType);
      map.put("sCustomerCode", sCustomerCode);
      map.put("sCustomerName", sCustomerName);
      map.put("sFixedDiscountRate", sFixedDiscountRate);
      map.put("sBuCode", sBuCode);
      map.put("sBuName", sBuName);
      map.put("sCompanyCode", sCompanyCode);
      map.put("sCompanyName", sCompanyName);
      map.put("sCompanyTaxNo", sCompanyTaxNo);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);
      map.put("sDivisionCode", sDivisionCode);
      map.put("sDivisionName", sDivisionName);
      map.put("sDistributionChannelCode", sDistributionChannelCode);
      map.put("sDistributionChannelName", sDistributionChannelName);
      map.put("sSalesDepartmentCode", sSalesDepartmentCode);
      map.put("sSalesDepartmentName", sSalesDepartmentName);
      map.put("sPlantCode", sPlantCode);
      map.put("sPlantName", sPlantName);
      map.put("pUnifyDocFlag", pUnifyDocFlag);
      map.put("pTenantDocFlag", pTenantDocFlag);
      map.put("pBeSplitFlag", pBeSplitFlag);
      map.put("pSplitDocFlag", pSplitDocFlag);
      map.put("pRefBeSplitDocId", pRefBeSplitDocId);
      map.put("pRefBeSplitDocNo", pRefBeSplitDocNo);
      map.put("sRevisedPONo", sRevisedPONo);
      map.put("pSysNo", pSysNo);

      map.put("grId.id", grIdId);
      return map;
  }

  public static ReceiptRreturnSettlementDetail fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceiptRreturnSettlementDetail entity = new ReceiptRreturnSettlementDetail();

    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastSettlementDate")) {
      Object obj = map.get("lastSettlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLastSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastSettlementDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementDate(null);
      }
    }
    if(map.containsKey("documentCategory")) {
      Object obj = map.get("documentCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithTax")) {
      Object obj = map.get("totalAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementSubNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManualDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalQty")) {
      Object obj = map.get("totalQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deductAmt")) {
      Object obj = map.get("deductAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeductAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeductAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeductAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeductAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeductAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deliveryDocNo")) {
      Object obj = map.get("deliveryDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoDate(null);
      }
    }
    if(map.containsKey("deductAmtWithoutTax")) {
      Object obj = map.get("deductAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeductAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeductAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeductAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeductAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeductAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithTax")) {
      Object obj = map.get("salesAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithoutTax")) {
      Object obj = map.get("salesAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("disRate")) {
      Object obj = map.get("disRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDisRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDisRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDisRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDisRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDisRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementDueDate")) {
      Object obj = map.get("settlementDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementDueDate(null);
      }
    }
    if(map.containsKey("settlementAmtWithTax")) {
      Object obj = map.get("settlementAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementAmtWithoutTax")) {
      Object obj = map.get("settlementAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFixedDiscountRate")) {
      Object obj = map.get("sFixedDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSFixedDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSFixedDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSFixedDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSFixedDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSFixedDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentCode")) {
      Object obj = map.get("sSalesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantCode")) {
      Object obj = map.get("sPlantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPlantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantName")) {
      Object obj = map.get("sPlantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPlantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sRevisedPONo")) {
      Object obj = map.get("sRevisedPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSRevisedPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysNo((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("grId.id")) {
       Object obj = map.get("grId.id");
       if(obj instanceof Long) {
         entity.setGrIdId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setGrIdId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastSettlementDate")) {
      Object obj = map.get("lastSettlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLastSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLastSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLastSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLastSettlementDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettlementDate(null);
      }
    }
    if(map.containsKey("documentCategory")) {
      Object obj = map.get("documentCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDocumentDate(null);
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithTax")) {
      Object obj = map.get("totalAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementSubNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setManualDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalQty")) {
      Object obj = map.get("totalQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deductAmt")) {
      Object obj = map.get("deductAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDeductAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDeductAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDeductAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeductAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDeductAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deliveryDocNo")) {
      Object obj = map.get("deliveryDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeliveryDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPoDate(null);
      }
    }
    if(map.containsKey("deductAmtWithoutTax")) {
      Object obj = map.get("deductAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDeductAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDeductAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDeductAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeductAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDeductAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithTax")) {
      Object obj = map.get("salesAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmtWithoutTax")) {
      Object obj = map.get("salesAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("disRate")) {
      Object obj = map.get("disRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDisRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDisRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDisRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDisRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDisRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementDueDate")) {
      Object obj = map.get("settlementDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettlementDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettlementDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSettlementDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettlementDueDate(null);
      }
    }
    if(map.containsKey("settlementAmtWithTax")) {
      Object obj = map.get("settlementAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSettlementAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSettlementAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSettlementAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSettlementAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSettlementAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementAmtWithoutTax")) {
      Object obj = map.get("settlementAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSettlementAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSettlementAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSettlementAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSettlementAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSettlementAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFixedDiscountRate")) {
      Object obj = map.get("sFixedDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSFixedDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSFixedDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSFixedDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSFixedDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSFixedDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentCode")) {
      Object obj = map.get("sSalesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantCode")) {
      Object obj = map.get("sPlantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSPlantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantName")) {
      Object obj = map.get("sPlantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSPlantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPRefBeSplitDocId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPRefBeSplitDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sRevisedPONo")) {
      Object obj = map.get("sRevisedPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSRevisedPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSysNo((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("grId.id")) {
    Object obj = map.get("grId.id");
    if(obj instanceof Long) {
        this.setGrIdId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setGrIdId(Long.parseLong((String)obj));
    }
  }
  }
}
