package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * execution_task_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-28
 */
public enum ExecutionTaskStatus {

    IDLE("idle", "待处理"),
    PROC("proc", "执行中"),
    DONE("done", "完成"),
    FAIL("fail", "失败"),
    CANCEL("cancel", "取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExecutionTaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExecutionTaskStatus fromCode(String code) {
        return Stream.of(ExecutionTaskStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
