package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * p_no_conversion_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-05-28
 */
public enum PNoConversionFlag {

    _0("0", "需要转换"),
    _1("1", "无需转换");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PNoConversionFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PNoConversionFlag fromCode(String code) {
        return Stream.of(PNoConversionFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
