package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_order
 * </p>
 *
 * @author ultraman
 * @since 2024-05-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 是否是最新版本
   */
  private Boolean latest;
  /**
   * 原始单据Id数组
   */
  private String srcids;
  /**
   * 数据MD5摘要
   */
  private String md5;
  /**
   * 所属租户
   */
  private String belongTenant;
  /**
   * 商超账号
   */
  private String collectionAccount;
  /**
   * 城市
   */
  private String purchaseCity;
  /**
   * 区域编码
   */
  private String regionCode;
  /**
   * 区域名称
   */
  private String regionName;
  /**
   * 零售商编码
   */
  private String purchaseRetailerId;
  /**
   * 零售商描述
   */
  private String purchaseRetailerName;
  /**
   * 业态编码
   */
  private String purchaseBusinessTypeNo;
  /**
   * 业态名称
   */
  private String purchaseBusinessTypeName;
  /**
   * 购方门店编码
   */
  private String purchaseStoreCode;
  /**
   * 购方门店GLN
   */
  private String purchaseStoreGLN;
  /**
   * 购方门店名称
   */
  private String purchaseStoreName;
  /**
   * 采购组织编码
   */
  private String purchasePurOrgCode;
  /**
   * 采购组织名称
   */
  private String purchasePurOrgName;
  /**
   * 购方统一社会信用代码
   */
  private String purchaseCompanyTaxNo;
  /**
   * 购方公司编码
   */
  private String purchaseCompanyCode;
  /**
   * 购方公司名称
   */
  private String purchaseCompanyName;
  /**
   * 采购组编码
   */
  private String purchaseGroupCode;
  /**
   * 采购组名称
   */
  private String purchaseGroupName;
  /**
   * 购方门店地址
   */
  private String purchaseStoreAddress;
  /**
   * 收货地址
   */
  private String receiveAddress;
  /**
   * 纸票收票地址
   */
  private String paperBillAddress;
  /**
   * 电票收票地址
   */
  private String elecBillAddress;
  /**
   * 订单创建人
   */
  private String createUser;
  /**
   * 订单更新人
   */
  private String updateUser;
  /**
   * 收货联系人
   */
  private String receiveContactPerson;
  /**
   * 购方联系电话
   */
  private String purchasePhone;
  /**
   * 购方传真
   */
  private String purchaseFax;
  /**
   * 购方邮箱
   */
  private String purchaseEmail;
  /**
   * 销方类型
   */
  private String sellerType;
  /**
   * 销方统一社会信用代码
   */
  private String sellerCompanyTaxNo;
  /**
   * 销方编码
   */
  private String sellerCode;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 发货地址
   */
  private String sellerShipAddress;
  /**
   * 销方联系电话
   */
  private String sellerPhone;
  /**
   * 销方传真
   */
  private String sellerFax;
  /**
   * 销方邮箱
   */
  private String sellerEmail;
  /**
   * 厂商名称
   */
  private String manufacturerName;
  /**
   * 厂商编码
   */
  private String manufacturerCode;
  /**
   * 采购订单编号
   */
  private String poNo;
  /**
   * 一揽子协议编号
   */
  private String bpaNo;
  /**
   * 版本号
   */
  private String versionNo;
  /**
   * 销售订单号
   */
  private String salesOrdNo;
  /**
   * 采购申请编号
   */
  private String purAppNo;
  /**
   * 采购申请行号
   */
  private String purAppLineNo;
  /**
   * 采购合同号
   */
  private String purContractNo;
  /**
   * 采购合同行号
   */
  private String purContractLineNo;
  /**
   * 订单类型
   */
  private String poType;
  /**
   * 订单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poDate;
  /**
   * 订单更新日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateDate;
  /**
   * 订单审批日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approveDate;
  /**
   * 销方确认日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime confirmDate;
  /**
   * 订单有效期
   */
  private Long validateDays;
  /**
   * 订单截止日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deadlineDate;
  /**
   * 订单取消日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poCancelDate;
  /**
   * 总金额（含税）
   */
  private BigDecimal totalAmt;
  /**
   * 订单状态
   */
  private String poStatus;
  /**
   * 取消标识
   */
  private Long cancelFlag;
  /**
   * 审批类型
   */
  private String approveType;
  /**
   * 补货状态
   */
  private String replenishStatus;
  /**
   * 补货标识
   */
  private String replenishFlag;
  /**
   * 补货方式
   */
  private String replenishMethod;
  /**
   * 折扣总金额（含税）
   */
  private BigDecimal discountTotalAmt;
  /**
   * 折扣率
   */
  private BigDecimal discountRate;
  /**
   * 是否促销
   */
  private String promtFlag;
  /**
   * 促销期数
   */
  private String promtPeriod;
  /**
   * 促销类型
   */
  private String promtType;
  /**
   * 币种编码
   */
  private String currencyCode;
  /**
   * 币种
   */
  private String currency;
  /**
   * 汇率日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exRateDate;
  /**
   * 汇率
   */
  private BigDecimal exRate;
  /**
   * 汇率类型
   */
  private String exRateType;
  /**
   * 是否允许打印
   */
  private String printFlag;
  /**
   * 打印次数
   */
  private String printCount;
  /**
   * 发运方式
   */
  private String shipMethod;
  /**
   * 物流模式
   */
  private String logisticsMode;
  /**
   * 发货类型
   */
  private String shipType;
  /**
   * 计划发货日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scheduleDeliveryDate;
  /**
   * 发货日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryDate;
  /**
   * 收货业务组织编码
   */
  private String receiveOrgCode;
  /**
   * 收货业务组织名称
   */
  private String receiveOrgName;
  /**
   * 实际收货日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiveDate;
  /**
   * 接收总数量
   */
  private BigDecimal poReceiveQty;
  /**
   * 结算财务组织编码
   */
  private String settlementOrgCode;
  /**
   * 结算财务组织名称
   */
  private String settlementOrgName;
  /**
   * 结算方式编码
   */
  private String settlementCode;
  /**
   * 结算方式名称
   */
  private String settlementName;
  /**
   * 付款类型
   */
  private String payType;
  /**
   * 付款条件编码
   */
  private String payCondtCode;
  /**
   * 付款条件
   */
  private String payCondt;
  /**
   * 付款折扣
   */
  private String payDiscount;
  /**
   * 备注
   */
  private String remark;
  /**
   * 扩展字段_字符串_1
   */
  private String extstr1;
  /**
   * 扩展字段_字符串_2
   */
  private String extstr2;
  /**
   * 扩展字段_字符串_3
   */
  private String extstr3;
  /**
   * 扩展字段_字符串_4
   */
  private String extstr4;
  /**
   * 扩展字段_字符串_5
   */
  private String extstr5;
  /**
   * 扩展字段_字符串_6
   */
  private String extstr6;
  /**
   * 扩展字段_字符串_7
   */
  private String extstr7;
  /**
   * 扩展字段_字符串_8
   */
  private String extstr8;
  /**
   * 扩展字段_字符串_9
   */
  private String extstr9;
  /**
   * 扩展字段_字符串_10
   */
  private String extstr10;
  /**
   * 模版变量Id
   */
  private String vvariableid;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 转换方式
   */
  private String docTransformer;
  /**
   * 业务id
   */
  private Long businessId;
  /**
   * 销方公司编码
   */
  private String sellerCompanyCode;
  /**
   * 销方公司名称
   */
  private String sellerCompanyName;
  /**
   * 业务Id
   */
  private String pBusinessId;
  /**
   * 单据来源
   */
  private String pSourceFrom;
  /**
   * 价格方式
   */
  private Long priceStatus;
  /**
   * 总金额（不含税）
   */
  private BigDecimal totalAmtWithoutTax;
  /**
   * 折扣总金额（不含税）
   */
  private BigDecimal discountTotalAmtWithoutTax;
  /**
   * 售达方编码
   */
  private String sSoldToCode;
  /**
   * 售达方名称
   */
  private String sSoldToName;
  /**
   * 送达方编码
   */
  private String sShipToCode;
  /**
   * 送达方名称
   */
  private String sShipToName;
  /**
   * 客户组编码
   */
  private String sCustomerGroupCode;
  /**
   * 客户组名称
   */
  private String sCustomerGroupName;
  /**
   * 客户类型
   */
  private String sCustomerType;
  /**
   * 客户编码
   */
  private String sCustomerCode;
  /**
   * 客户名称
   */
  private String sCustomerName;
  /**
   * 固定折扣率
   */
  private String sFixedDiscountRate;
  /**
   * 业务单元编码
   */
  private String sBuCode;
  /**
   * 业务单元名称
   */
  private String sBuName;
  /**
   * 销售公司编码
   */
  private String sCompanyCode;
  /**
   * 销售公司名称
   */
  private String sCompanyName;
  /**
   * 销售公司税号
   */
  private String sCompanyTaxNo;
  /**
   * 销售组织编码
   */
  private String sSalesOrganizationCode;
  /**
   * 销售组织名称
   */
  private String sSalesOrganizationName;
  /**
   * 销售组编码
   */
  private String sSalesGroupCode;
  /**
   * 销售组名称
   */
  private String sSalesGroupName;
  /**
   * 产品组编码
   */
  private String sDivisionCode;
  /**
   * 产品组名称
   */
  private String sDivisionName;
  /**
   * 分销渠道编码
   */
  private String sDistributionChannelCode;
  /**
   * 分销渠道名称
   */
  private String sDistributionChannelName;
  /**
   * 销售部门编码
   */
  private String sSalesDepartmentCode;
  /**
   * 销售部门名称
   */
  private String sSalesDepartmentName;
  /**
   * 工厂编码
   */
  private String sPlantCode;
  /**
   * 工厂名称
   */
  private String sPlantName;
  /**
   * 上级订单编号
   */
  private String parentPoNo;
  /**
   * 商超原单文件地址
   */
  private String pSourceFileURL;
  /**
   * PDF文件地址
   */
  private String pdfURL;
  /**
   * 是否零价订单
   */
  private String zeroPriceFlag;
  /**
   * PDF文件类型
   */
  private String pdfFileType;
  /**
   * 统一单据标记
   */
  private Boolean pUnifyDocFlag;
  /**
   * 租户单据标记
   */
  private Boolean pTenantDocFlag;
  /**
   * 数据MD5
   */
  private String pDataMD5;
  /**
   * 系统单据编号
   */
  private String pSysNo;
  /**
   * 商品数量合计
   */
  private BigDecimal itemTotalQty;
  /**
   * 系统单据类型
   */
  private String pSysDocType;
  /**
   * 修订采购订单编号
   */
  private String sRevisedPONo;
  /**
   * 无需转换
   */
  private String pNoConversionFlag;
  /**
   * 订单送货开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryStartDate;
  /**
   * 收货库房编码
   */
  private String receiveWarehouseCode;
  /**
   * 收货库房名称
   */
  private String receiveWarehouseName;
  /**
   * 要货(代送)门店编码
   */
  private String requireStoreCode;
  /**
   * 要货(代送)门店名称
   */
  private String requireStoreName;
  /**
   * 商品行条目数
   */
  private Long itemLineCount;
  /**
   * 采集时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectionDate;
  /**
   * 日志Id
   */
  private String traceId;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("md5", md5);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseCity", purchaseCity);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("purchasePurOrgCode", purchasePurOrgCode);
      map.put("purchasePurOrgName", purchasePurOrgName);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("purchaseGroupCode", purchaseGroupCode);
      map.put("purchaseGroupName", purchaseGroupName);
      map.put("purchaseStoreAddress", purchaseStoreAddress);
      map.put("receiveAddress", receiveAddress);
      map.put("paperBillAddress", paperBillAddress);
      map.put("elecBillAddress", elecBillAddress);
      map.put("createUser", createUser);
      map.put("updateUser", updateUser);
      map.put("receiveContactPerson", receiveContactPerson);
      map.put("purchasePhone", purchasePhone);
      map.put("purchaseFax", purchaseFax);
      map.put("purchaseEmail", purchaseEmail);
      map.put("sellerType", sellerType);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("sellerShipAddress", sellerShipAddress);
      map.put("sellerPhone", sellerPhone);
      map.put("sellerFax", sellerFax);
      map.put("sellerEmail", sellerEmail);
      map.put("manufacturerName", manufacturerName);
      map.put("manufacturerCode", manufacturerCode);
      map.put("poNo", poNo);
      map.put("bpaNo", bpaNo);
      map.put("versionNo", versionNo);
      map.put("salesOrdNo", salesOrdNo);
      map.put("purAppNo", purAppNo);
      map.put("purAppLineNo", purAppLineNo);
      map.put("purContractNo", purContractNo);
      map.put("purContractLineNo", purContractLineNo);
      map.put("poType", poType);
      map.put("poDate", BocpGenUtils.toTimestamp(poDate));
      map.put("updateDate", BocpGenUtils.toTimestamp(updateDate));
      map.put("approveDate", BocpGenUtils.toTimestamp(approveDate));
      map.put("confirmDate", BocpGenUtils.toTimestamp(confirmDate));
      map.put("validateDays", validateDays);
      map.put("deadlineDate", BocpGenUtils.toTimestamp(deadlineDate));
      map.put("poCancelDate", BocpGenUtils.toTimestamp(poCancelDate));
      map.put("totalAmt", totalAmt);
      map.put("poStatus", poStatus);
      map.put("cancelFlag", cancelFlag);
      map.put("approveType", approveType);
      map.put("replenishStatus", replenishStatus);
      map.put("replenishFlag", replenishFlag);
      map.put("replenishMethod", replenishMethod);
      map.put("discountTotalAmt", discountTotalAmt);
      map.put("discountRate", discountRate);
      map.put("promtFlag", promtFlag);
      map.put("promtPeriod", promtPeriod);
      map.put("promtType", promtType);
      map.put("currencyCode", currencyCode);
      map.put("currency", currency);
      map.put("exRateDate", BocpGenUtils.toTimestamp(exRateDate));
      map.put("exRate", exRate);
      map.put("exRateType", exRateType);
      map.put("printFlag", printFlag);
      map.put("printCount", printCount);
      map.put("shipMethod", shipMethod);
      map.put("logisticsMode", logisticsMode);
      map.put("shipType", shipType);
      map.put("scheduleDeliveryDate", BocpGenUtils.toTimestamp(scheduleDeliveryDate));
      map.put("deliveryDate", BocpGenUtils.toTimestamp(deliveryDate));
      map.put("receiveOrgCode", receiveOrgCode);
      map.put("receiveOrgName", receiveOrgName);
      map.put("receiveDate", BocpGenUtils.toTimestamp(receiveDate));
      map.put("poReceiveQty", poReceiveQty);
      map.put("settlementOrgCode", settlementOrgCode);
      map.put("settlementOrgName", settlementOrgName);
      map.put("settlementCode", settlementCode);
      map.put("settlementName", settlementName);
      map.put("payType", payType);
      map.put("payCondtCode", payCondtCode);
      map.put("payCondt", payCondt);
      map.put("payDiscount", payDiscount);
      map.put("remark", remark);
      map.put("extstr1", extstr1);
      map.put("extstr2", extstr2);
      map.put("extstr3", extstr3);
      map.put("extstr4", extstr4);
      map.put("extstr5", extstr5);
      map.put("extstr6", extstr6);
      map.put("extstr7", extstr7);
      map.put("extstr8", extstr8);
      map.put("extstr9", extstr9);
      map.put("extstr10", extstr10);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("docTransformer", docTransformer);
      map.put("businessId", businessId);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("pBusinessId", pBusinessId);
      map.put("pSourceFrom", pSourceFrom);
      map.put("priceStatus", priceStatus);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("discountTotalAmtWithoutTax", discountTotalAmtWithoutTax);
      map.put("sSoldToCode", sSoldToCode);
      map.put("sSoldToName", sSoldToName);
      map.put("sShipToCode", sShipToCode);
      map.put("sShipToName", sShipToName);
      map.put("sCustomerGroupCode", sCustomerGroupCode);
      map.put("sCustomerGroupName", sCustomerGroupName);
      map.put("sCustomerType", sCustomerType);
      map.put("sCustomerCode", sCustomerCode);
      map.put("sCustomerName", sCustomerName);
      map.put("sFixedDiscountRate", sFixedDiscountRate);
      map.put("sBuCode", sBuCode);
      map.put("sBuName", sBuName);
      map.put("sCompanyCode", sCompanyCode);
      map.put("sCompanyName", sCompanyName);
      map.put("sCompanyTaxNo", sCompanyTaxNo);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("sDivisionCode", sDivisionCode);
      map.put("sDivisionName", sDivisionName);
      map.put("sDistributionChannelCode", sDistributionChannelCode);
      map.put("sDistributionChannelName", sDistributionChannelName);
      map.put("sSalesDepartmentCode", sSalesDepartmentCode);
      map.put("sSalesDepartmentName", sSalesDepartmentName);
      map.put("sPlantCode", sPlantCode);
      map.put("sPlantName", sPlantName);
      map.put("parentPoNo", parentPoNo);
      map.put("pSourceFileURL", pSourceFileURL);
      map.put("pdfURL", pdfURL);
      map.put("zeroPriceFlag", zeroPriceFlag);
      map.put("pdfFileType", pdfFileType);
      map.put("pUnifyDocFlag", pUnifyDocFlag);
      map.put("pTenantDocFlag", pTenantDocFlag);
      map.put("pDataMD5", pDataMD5);
      map.put("pSysNo", pSysNo);
      map.put("itemTotalQty", itemTotalQty);
      map.put("pSysDocType", pSysDocType);
      map.put("sRevisedPONo", sRevisedPONo);
      map.put("pNoConversionFlag", pNoConversionFlag);
      map.put("deliveryStartDate", BocpGenUtils.toTimestamp(deliveryStartDate));
      map.put("receiveWarehouseCode", receiveWarehouseCode);
      map.put("receiveWarehouseName", receiveWarehouseName);
      map.put("requireStoreCode", requireStoreCode);
      map.put("requireStoreName", requireStoreName);
      map.put("itemLineCount", itemLineCount);
      map.put("collectionDate", BocpGenUtils.toTimestamp(collectionDate));
      map.put("traceId", traceId);

      return map;
  }

  public static PurchaseOrder fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrder entity = new PurchaseOrder();

    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCity")) {
      Object obj = map.get("purchaseCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePurOrgCode")) {
      Object obj = map.get("purchasePurOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasePurOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePurOrgName")) {
      Object obj = map.get("purchasePurOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasePurOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseGroupCode")) {
      Object obj = map.get("purchaseGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseGroupName")) {
      Object obj = map.get("purchaseGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveAddress")) {
      Object obj = map.get("receiveAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperBillAddress")) {
      Object obj = map.get("paperBillAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaperBillAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elecBillAddress")) {
      Object obj = map.get("elecBillAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElecBillAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveContactPerson")) {
      Object obj = map.get("receiveContactPerson");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveContactPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseFax")) {
      Object obj = map.get("purchaseFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseEmail")) {
      Object obj = map.get("purchaseEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerShipAddress")) {
      Object obj = map.get("sellerShipAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerShipAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerPhone")) {
      Object obj = map.get("sellerPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerFax")) {
      Object obj = map.get("sellerFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerEmail")) {
      Object obj = map.get("sellerEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufacturerName")) {
      Object obj = map.get("manufacturerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManufacturerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufacturerCode")) {
      Object obj = map.get("manufacturerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManufacturerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bpaNo")) {
      Object obj = map.get("bpaNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBpaNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrdNo")) {
      Object obj = map.get("salesOrdNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purAppNo")) {
      Object obj = map.get("purAppNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurAppNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purAppLineNo")) {
      Object obj = map.get("purAppLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurAppLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purContractNo")) {
      Object obj = map.get("purContractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purContractLineNo")) {
      Object obj = map.get("purContractLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurContractLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poType")) {
      Object obj = map.get("poType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApproveDate(null);
      }
    }
    if(map.containsKey("confirmDate")) {
      Object obj = map.get("confirmDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConfirmDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setConfirmDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfirmDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConfirmDate(null);
      }
    }
    if(map.containsKey("validateDays")) {
      Object obj = map.get("validateDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setValidateDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setValidateDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setValidateDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deadlineDate")) {
      Object obj = map.get("deadlineDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeadlineDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeadlineDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeadlineDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeadlineDate(null);
      }
    }
    if(map.containsKey("poCancelDate")) {
      Object obj = map.get("poCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPoCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoCancelDate(null);
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poStatus")) {
      Object obj = map.get("poStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCancelFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCancelFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCancelFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("approveType")) {
      Object obj = map.get("approveType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApproveType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishStatus")) {
      Object obj = map.get("replenishStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplenishStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishFlag")) {
      Object obj = map.get("replenishFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplenishFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishMethod")) {
      Object obj = map.get("replenishMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplenishMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtPeriod")) {
      Object obj = map.get("promtPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtType")) {
      Object obj = map.get("promtType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currencyCode")) {
      Object obj = map.get("currencyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrencyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printFlag")) {
      Object obj = map.get("printFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printCount")) {
      Object obj = map.get("printCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipType")) {
      Object obj = map.get("shipType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scheduleDeliveryDate")) {
      Object obj = map.get("scheduleDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setScheduleDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScheduleDeliveryDate(null);
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryDate(null);
      }
    }
    if(map.containsKey("receiveOrgCode")) {
      Object obj = map.get("receiveOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveOrgName")) {
      Object obj = map.get("receiveOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiveDate(null);
      }
    }
    if(map.containsKey("poReceiveQty")) {
      Object obj = map.get("poReceiveQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPoReceiveQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPoReceiveQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPoReceiveQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoReceiveQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPoReceiveQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgCode")) {
      Object obj = map.get("settlementOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgName")) {
      Object obj = map.get("settlementOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondt")) {
      Object obj = map.get("payCondt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payDiscount")) {
      Object obj = map.get("payDiscount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmtWithoutTax")) {
      Object obj = map.get("discountTotalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFixedDiscountRate")) {
      Object obj = map.get("sFixedDiscountRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSFixedDiscountRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentCode")) {
      Object obj = map.get("sSalesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantCode")) {
      Object obj = map.get("sPlantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPlantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantName")) {
      Object obj = map.get("sPlantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPlantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentPoNo")) {
      Object obj = map.get("parentPoNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParentPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFileURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfURL")) {
      Object obj = map.get("pdfURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroPriceFlag")) {
      Object obj = map.get("zeroPriceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroPriceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfFileType")) {
      Object obj = map.get("pdfFileType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pDataMD5")) {
      Object obj = map.get("pDataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemTotalQty")) {
      Object obj = map.get("itemTotalQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemTotalQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemTotalQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemTotalQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemTotalQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemTotalQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pSysDocType")) {
      Object obj = map.get("pSysDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysDocType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sRevisedPONo")) {
      Object obj = map.get("sRevisedPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSRevisedPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pNoConversionFlag")) {
      Object obj = map.get("pNoConversionFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPNoConversionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryStartDate")) {
      Object obj = map.get("deliveryStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeliveryStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryStartDate(null);
      }
    }
    if(map.containsKey("receiveWarehouseCode")) {
      Object obj = map.get("receiveWarehouseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveWarehouseName")) {
      Object obj = map.get("receiveWarehouseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requireStoreCode")) {
      Object obj = map.get("requireStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequireStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requireStoreName")) {
      Object obj = map.get("requireStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequireStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemLineCount")) {
      Object obj = map.get("itemLineCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItemLineCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemLineCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItemLineCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectionDate(null);
      }
    }
    if(map.containsKey("traceId")) {
      Object obj = map.get("traceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTraceId((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCity")) {
      Object obj = map.get("purchaseCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePurOrgCode")) {
      Object obj = map.get("purchasePurOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasePurOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePurOrgName")) {
      Object obj = map.get("purchasePurOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasePurOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseGroupCode")) {
      Object obj = map.get("purchaseGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseGroupName")) {
      Object obj = map.get("purchaseGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveAddress")) {
      Object obj = map.get("receiveAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperBillAddress")) {
      Object obj = map.get("paperBillAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaperBillAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elecBillAddress")) {
      Object obj = map.get("elecBillAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElecBillAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveContactPerson")) {
      Object obj = map.get("receiveContactPerson");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveContactPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseFax")) {
      Object obj = map.get("purchaseFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseEmail")) {
      Object obj = map.get("purchaseEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerShipAddress")) {
      Object obj = map.get("sellerShipAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerShipAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerPhone")) {
      Object obj = map.get("sellerPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerFax")) {
      Object obj = map.get("sellerFax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerFax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerEmail")) {
      Object obj = map.get("sellerEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufacturerName")) {
      Object obj = map.get("manufacturerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setManufacturerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufacturerCode")) {
      Object obj = map.get("manufacturerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setManufacturerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bpaNo")) {
      Object obj = map.get("bpaNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBpaNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrdNo")) {
      Object obj = map.get("salesOrdNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purAppNo")) {
      Object obj = map.get("purAppNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurAppNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purAppLineNo")) {
      Object obj = map.get("purAppLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurAppLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purContractNo")) {
      Object obj = map.get("purContractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purContractLineNo")) {
      Object obj = map.get("purContractLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurContractLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poType")) {
      Object obj = map.get("poType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPoDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setApproveDate(null);
      }
    }
    if(map.containsKey("confirmDate")) {
      Object obj = map.get("confirmDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setConfirmDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setConfirmDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setConfirmDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setConfirmDate(null);
      }
    }
    if(map.containsKey("validateDays")) {
      Object obj = map.get("validateDays");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setValidateDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setValidateDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setValidateDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deadlineDate")) {
      Object obj = map.get("deadlineDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeadlineDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeadlineDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeadlineDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeadlineDate(null);
      }
    }
    if(map.containsKey("poCancelDate")) {
      Object obj = map.get("poCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPoCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPoCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPoCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPoCancelDate(null);
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poStatus")) {
      Object obj = map.get("poStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCancelFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCancelFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCancelFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("approveType")) {
      Object obj = map.get("approveType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApproveType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishStatus")) {
      Object obj = map.get("replenishStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReplenishStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishFlag")) {
      Object obj = map.get("replenishFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReplenishFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishMethod")) {
      Object obj = map.get("replenishMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReplenishMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtPeriod")) {
      Object obj = map.get("promtPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPromtPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promtType")) {
      Object obj = map.get("promtType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPromtType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currencyCode")) {
      Object obj = map.get("currencyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCurrencyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printFlag")) {
      Object obj = map.get("printFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrintFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printCount")) {
      Object obj = map.get("printCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrintCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShipMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipType")) {
      Object obj = map.get("shipType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShipType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scheduleDeliveryDate")) {
      Object obj = map.get("scheduleDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setScheduleDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setScheduleDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setScheduleDeliveryDate(null);
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeliveryDate(null);
      }
    }
    if(map.containsKey("receiveOrgCode")) {
      Object obj = map.get("receiveOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveOrgName")) {
      Object obj = map.get("receiveOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReceiveDate(null);
      }
    }
    if(map.containsKey("poReceiveQty")) {
      Object obj = map.get("poReceiveQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPoReceiveQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPoReceiveQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPoReceiveQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPoReceiveQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPoReceiveQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgCode")) {
      Object obj = map.get("settlementOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementOrgName")) {
      Object obj = map.get("settlementOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayCondtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondt")) {
      Object obj = map.get("payCondt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayCondt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payDiscount")) {
      Object obj = map.get("payDiscount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmtWithoutTax")) {
      Object obj = map.get("discountTotalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFixedDiscountRate")) {
      Object obj = map.get("sFixedDiscountRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSFixedDiscountRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentCode")) {
      Object obj = map.get("sSalesDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantCode")) {
      Object obj = map.get("sPlantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSPlantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPlantName")) {
      Object obj = map.get("sPlantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSPlantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentPoNo")) {
      Object obj = map.get("parentPoNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setParentPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSourceFileURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfURL")) {
      Object obj = map.get("pdfURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroPriceFlag")) {
      Object obj = map.get("zeroPriceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZeroPriceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfFileType")) {
      Object obj = map.get("pdfFileType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pDataMD5")) {
      Object obj = map.get("pDataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSysNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemTotalQty")) {
      Object obj = map.get("itemTotalQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setItemTotalQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setItemTotalQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setItemTotalQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setItemTotalQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setItemTotalQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pSysDocType")) {
      Object obj = map.get("pSysDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSysDocType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sRevisedPONo")) {
      Object obj = map.get("sRevisedPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSRevisedPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pNoConversionFlag")) {
      Object obj = map.get("pNoConversionFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPNoConversionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryStartDate")) {
      Object obj = map.get("deliveryStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeliveryStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeliveryStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeliveryStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeliveryStartDate(null);
      }
    }
    if(map.containsKey("receiveWarehouseCode")) {
      Object obj = map.get("receiveWarehouseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveWarehouseName")) {
      Object obj = map.get("receiveWarehouseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requireStoreCode")) {
      Object obj = map.get("requireStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRequireStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requireStoreName")) {
      Object obj = map.get("requireStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRequireStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemLineCount")) {
      Object obj = map.get("itemLineCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setItemLineCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setItemLineCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setItemLineCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCollectionDate(null);
      }
    }
    if(map.containsKey("traceId")) {
      Object obj = map.get("traceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTraceId((String)obj);
        }
      } else{
      }
    }
  }
}
