package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * batch_transfer_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-31
 */
public enum BatchTransferStatus {

    _1("1", "成功"),
    _3("3", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BatchTransferStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BatchTransferStatus fromCode(String code) {
        return Stream.of(BatchTransferStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
