package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_category
 * </p>
 *
 * @author ultraman
 * @since 2024-05-31
 */
public enum DocumentCategory {

    GRN("GRN", "收货单"),
    RTV("RTV", "退货单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocumentCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentCategory fromCode(String code) {
        return Stream.of(DocumentCategory.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
