package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_order_store_detail
 * </p>
 *
 * @author ultraman
 * @since 2024-05-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderStoreDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 行编号
   */
  private String storeLineNo;
  /**
   * 行业务ID
   */
  private String pBusinessLineId;
  /**
   * 行数据MD5
   */
  private String pDataLineMD5;
  /**
   * 门店单号
   */
  private String storePoNo;
  /**
   * 行门店编码
   */
  private String lineStoreCode;
  /**
   * 行门店名称
   */
  private String lineStoreName;
  /**
   * 品类编码
   */
  private String categoryCode;
  /**
   * 品类名称
   */
  private String categoryDesc;
  /**
   * 商品名称
   */
  private String itemDesc;
  /**
   * 商品编码
   */
  private String itemCode;
  /**
   * 商品条码
   */
  private String barcode;
  /**
   * 商品子编码
   */
  private String itemSubCode;
  /**
   * 批量包装规格
   */
  private String packageSize;
  /**
   * 批量包装数量
   */
  private BigDecimal packageQty;
  /**
   * 批量包装单位
   */
  private String packageUnit;
  /**
   * 批量包装单价（不含税）
   */
  private BigDecimal packageUnitPriceWithoutTax;
  /**
   * 批量包装单价（含税）
   */
  private BigDecimal packageUnitPriceWithTax;
  /**
   * 供应商商品编码
   */
  private String cusItemCode;
  /**
   * 单据单位
   */
  private String unit;
  /**
   * 单据单位数量
   */
  private BigDecimal qty;
  /**
   * 单价（不含税）
   */
  private BigDecimal unitPriceWithoutTax;
  /**
   * 单价（含税）
   */
  private BigDecimal unitPriceWithTax;
  /**
   * 金额（不含税）
   */
  private BigDecimal amountWithoutTax;
  /**
   * 金额（含税）
   */
  private BigDecimal amountWithTax;
  /**
   * 库房
   */
  private String inventory;
  /**
   * 税收分类
   */
  private String taxType;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 折扣率
   */
  private BigDecimal discountRate;
  /**
   * 折扣金额
   */
  private BigDecimal discountAmt;
  /**
   * 是否促销
   */
  private String promtFlag;
  /**
   * 是否赠品
   */
  private String freeFlag;
  /**
   * 赠品数量
   */
  private BigDecimal freeQty;
  /**
   * 最低起订量
   */
  private BigDecimal minOrdQty;
  /**
   * 备注
   */
  private String remark;
  /**
   * 确认数量
   */
  private BigDecimal confirmQty;
  /**
   * 商品分销标记
   */
  private String pDistributeFlag;
  /**
   * 无需转换
   */
  private String pNoConversionFlag;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 purchaseOrder
   */
  private Long storeIdId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("storeLineNo", storeLineNo);
      map.put("pBusinessLineId", pBusinessLineId);
      map.put("pDataLineMD5", pDataLineMD5);
      map.put("storePoNo", storePoNo);
      map.put("lineStoreCode", lineStoreCode);
      map.put("lineStoreName", lineStoreName);
      map.put("categoryCode", categoryCode);
      map.put("categoryDesc", categoryDesc);
      map.put("itemDesc", itemDesc);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemSubCode", itemSubCode);
      map.put("packageSize", packageSize);
      map.put("packageQty", packageQty);
      map.put("packageUnit", packageUnit);
      map.put("packageUnitPriceWithoutTax", packageUnitPriceWithoutTax);
      map.put("packageUnitPriceWithTax", packageUnitPriceWithTax);
      map.put("cusItemCode", cusItemCode);
      map.put("unit", unit);
      map.put("qty", qty);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("inventory", inventory);
      map.put("taxType", taxType);
      map.put("taxRate", taxRate);
      map.put("discountRate", discountRate);
      map.put("discountAmt", discountAmt);
      map.put("promtFlag", promtFlag);
      map.put("freeFlag", freeFlag);
      map.put("freeQty", freeQty);
      map.put("minOrdQty", minOrdQty);
      map.put("remark", remark);
      map.put("confirmQty", confirmQty);
      map.put("pDistributeFlag", pDistributeFlag);
      map.put("pNoConversionFlag", pNoConversionFlag);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("storeId.id", storeIdId);
      return map;
  }

  public static PurchaseOrderStoreDetail fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderStoreDetail entity = new PurchaseOrderStoreDetail();

    if(map.containsKey("storeLineNo")) {
      Object obj = map.get("storeLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessLineId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPDataLineMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storePoNo")) {
      Object obj = map.get("storePoNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStorePoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineStoreCode")) {
      Object obj = map.get("lineStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineStoreName")) {
      Object obj = map.get("lineStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithoutTax")) {
      Object obj = map.get("packageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithTax")) {
      Object obj = map.get("packageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCusItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inventory")) {
      Object obj = map.get("inventory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeFlag")) {
      Object obj = map.get("freeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeQty")) {
      Object obj = map.get("freeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdQty")) {
      Object obj = map.get("minOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirmQty")) {
      Object obj = map.get("confirmQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setConfirmQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setConfirmQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setConfirmQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfirmQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setConfirmQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pDistributeFlag")) {
      Object obj = map.get("pDistributeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPDistributeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pNoConversionFlag")) {
      Object obj = map.get("pNoConversionFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPNoConversionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("storeId.id")) {
       Object obj = map.get("storeId.id");
       if(obj instanceof Long) {
         entity.setStoreIdId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setStoreIdId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("storeLineNo")) {
      Object obj = map.get("storeLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPBusinessLineId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPDataLineMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storePoNo")) {
      Object obj = map.get("storePoNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStorePoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineStoreCode")) {
      Object obj = map.get("lineStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLineStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineStoreName")) {
      Object obj = map.get("lineStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLineStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCategoryDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithoutTax")) {
      Object obj = map.get("packageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithTax")) {
      Object obj = map.get("packageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCusItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inventory")) {
      Object obj = map.get("inventory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeFlag")) {
      Object obj = map.get("freeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFreeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeQty")) {
      Object obj = map.get("freeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdQty")) {
      Object obj = map.get("minOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirmQty")) {
      Object obj = map.get("confirmQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setConfirmQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setConfirmQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setConfirmQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setConfirmQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setConfirmQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pDistributeFlag")) {
      Object obj = map.get("pDistributeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPDistributeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pNoConversionFlag")) {
      Object obj = map.get("pNoConversionFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPNoConversionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("storeId.id")) {
    Object obj = map.get("storeId.id");
    if(obj instanceof Long) {
        this.setStoreIdId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setStoreIdId(Long.parseLong((String)obj));
    }
  }
  }
}
