package com.xforceplus.ultraman.app.arterydocument.metadata.validator;

import com.xforceplus.ultraman.app.arterydocument.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.arterydocument.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-05-31
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PSourceFrom.class)) {
            isValid = null != PSourceFrom.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerClearingStatus.class)) {
            isValid = null != SellerClearingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerClearingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerOffsetStatus.class)) {
            isValid = null != SellerOffsetStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerOffsetStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementSourceFrom.class)) {
            isValid = null != SettlementSourceFrom.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceStatus.class)) {
            isValid = null != PriceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentCategory.class)) {
            isValid = null != DocumentCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DocumentCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceStatus.class)) {
            isValid = null != NoInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceReasonDesc.class)) {
            isValid = null != NoInvoiceReasonDesc.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoInvoiceReasonDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffType.class)) {
            isValid = null != WriteOffType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WriteOffType.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffStatus.class)) {
            isValid = null != WriteOffStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WriteOffStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingRefSettlementBindingStatus.class)) {
            isValid = null != BillingRefSettlementBindingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillingRefSettlementBindingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingType.class)) {
            isValid = null != BillingType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillingType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedInvoiceFlag.class)) {
            isValid = null != RedInvoiceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(TransferStatus.class)) {
            isValid = null != TransferStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TransferStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentType.class)) {
            isValid = null != DocumentType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DocumentType.class.getSimpleName());
            }
        }
        if(clazz.equals(PageElementName.class)) {
            isValid = null != PageElementName.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PageElementName.class.getSimpleName());
            }
        }
        if(clazz.equals(ExpenseDetailSourceType.class)) {
            isValid = null != ExpenseDetailSourceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExpenseDetailSourceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpTransmitStatus.class)) {
            isValid = null != ErpTransmitStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErpTransmitStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = null != CheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessTagLevel.class)) {
            isValid = null != BusinessTagLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessTagLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(SupportStatus.class)) {
            isValid = null != SupportStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SupportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CaptureMethod.class)) {
            isValid = null != CaptureMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CaptureMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(PosApprovalStatus.class)) {
            isValid = null != PosApprovalStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PosApprovalStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BatchTransferStatus.class)) {
            isValid = null != BatchTransferStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BatchTransferStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = null != DataStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataIssueStatus.class)) {
            isValid = null != DataIssueStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataIssueStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StatisticalType.class)) {
            isValid = null != StatisticalType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StatisticalType.class.getSimpleName());
            }
        }
        if(clazz.equals(CaptureType.class)) {
            isValid = null != CaptureType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CaptureType.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveStatus.class)) {
            isValid = null != ActiveStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ActiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = null != ConversionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(WarningStatus.class)) {
            isValid = null != WarningStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WarningStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SendFlag.class)) {
            isValid = null != SendFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SendFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SuitType.class)) {
            isValid = null != SuitType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SuitType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionIgnoreReason.class)) {
            isValid = null != ExceptionIgnoreReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExceptionIgnoreReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpCallbackStatus.class)) {
            isValid = null != ErpCallbackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErpCallbackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PoSysDocType.class)) {
            isValid = null != PoSysDocType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PoSysDocType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderGoodsManageType.class)) {
            isValid = null != OrderGoodsManageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderGoodsManageType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsType.class)) {
            isValid = null != GoodsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(PosDateSource.class)) {
            isValid = null != PosDateSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PosDateSource.class.getSimpleName());
            }
        }
        if(clazz.equals(PNoConversionFlag.class)) {
            isValid = null != PNoConversionFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PNoConversionFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PDistributeFlag.class)) {
            isValid = null != PDistributeFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PDistributeFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DocTransferState.class)) {
            isValid = null != DocTransferState.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DocTransferState.class.getSimpleName());
            }
        }
        if(clazz.equals(AppendStatus.class)) {
            isValid = null != AppendStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AppendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LinereservationDeliveryNoteStatus.class)) {
            isValid = null != LinereservationDeliveryNoteStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LinereservationDeliveryNoteStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExecutionTaskStatus.class)) {
            isValid = null != ExecutionTaskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExecutionTaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EnumTaskType.class)) {
            isValid = null != EnumTaskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnumTaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnumBusinessType.class)) {
            isValid = null != EnumBusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnumBusinessType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
