package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * application_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum ApplicationStatus {

    _1("1", "待提交"),
    _2("2", "已提交");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplicationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplicationStatus fromCode(String code) {
        return Stream.of(ApplicationStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
