package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * enum_business_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum EnumBusinessType {

    _0("0", "无类型"),
    _1("1", "送货预约");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnumBusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EnumBusinessType fromCode(String code) {
        return Stream.of(EnumBusinessType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
