package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * linereservation_delivery_note_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum LinereservationDeliveryNoteStatus {

    _0("0", "待预约"),
    _1("1", "预约中"),
    _2("2", "已预约"),
    _3("3", "预约异常"),
    _4("4", "取消预约");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LinereservationDeliveryNoteStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LinereservationDeliveryNoteStatus fromCode(String code) {
        return Stream.of(LinereservationDeliveryNoteStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
