package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_goods_manage_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum OrderGoodsManageType {

    SINGLE_ORDER("singleOrder", "单张订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderGoodsManageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderGoodsManageType fromCode(String code) {
        return Stream.of(OrderGoodsManageType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
