package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * page_element_name
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum PageElementName {

    MAIN_TABLE_HEADER("MAIN_TABLE_HEADER", "主要表单字段"),
    BUTTON("BUTTON", "按钮字段"),
    IMPORT("IMPORT", "导入模板字段");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PageElementName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PageElementName fromCode(String code) {
        return Stream.of(PageElementName.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
