package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * processing_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum ProcessingStatus {

    _1("1", "待处理"),
    _2("2", "处理中"),
    _3("3", "处理成功"),
    _4("4", "处理失败"),
    _0("0", "无需处理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessingStatus fromCode(String code) {
        return Stream.of(ProcessingStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
