package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * retry_task_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum RetryTaskStatus {

    _0("0", "待执行"),
    _1("1", "成功"),
    _2("2", "失败"),
    _3("3", "中止"),
    _4("4", "执行中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RetryTaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RetryTaskStatus fromCode(String code) {
        return Stream.of(RetryTaskStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
