package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * account_secret_key_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum AccountSecretKeyStatus {

    _0("0", "待生成"),
    _1("1", "已更新"),
    _2("2", "密钥异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AccountSecretKeyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountSecretKeyStatus fromCode(String code) {
        return Stream.of(AccountSecretKeyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
