package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * application_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum ApplicationType {

    _1("1", "新增账号"),
    _2("2", "关闭账号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplicationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplicationType fromCode(String code) {
        return Stream.of(ApplicationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
