package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum BillStatus {

    DRAFT("draft", "草稿"),
    CONFIRMED("confirmed", "已提交"),
    POSTED("posted", "已过账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillStatus fromCode(String code) {
        return Stream.of(BillStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
