package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * billing_source_from
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum BillingSourceFrom {

    _1("1", "前台功能"),
    _2("2", "业务单"),
    _3("3", "结算对账"),
    _4("4", "原单据系统"),
    _5("5", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillingSourceFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillingSourceFrom fromCode(String code) {
        return Stream.of(BillingSourceFrom.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
