package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * capture_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum CaptureType {

    WEBPAGE("WEBPAGE", "网页采集"),
    API("API", "接口采集"),
    EDI("EDI", "EDI采集"),
    CLIENT("CLIENT", "客户端"),
    GONGZHONGHAO("GONGZHONGHAO", "微信公众号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CaptureType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CaptureType fromCode(String code) {
        return Stream.of(CaptureType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
