package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_issue_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum DataIssueStatus {

    _0("0", "未下发"),
    _1("1", "已下发");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataIssueStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataIssueStatus fromCode(String code) {
        return Stream.of(DataIssueStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
