package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_pool
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum DocumentPool {

    UNIFIED_POOL("unifiedPool", "统一单据池"),
    TENANT_POOL("tenantPool", "租户单据池");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocumentPool(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentPool fromCode(String code) {
        return Stream.of(DocumentPool.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
